
//Send Arduino data from its pins via OSC

//Credits to Jerome Dupraz & Retocama  

//Colorsound 011
// you can download arduino z-osc library from here https://github.com/djiamnot/Z_OSC
// you can download arduino code and vvvv patch from here: http://vvvv.org/contribution/arduinoosc

#include <SPI.h>
#include <Ethernet.h> // version IDE 0022 and Arduino UNO 

#include <Z_OSC.h>

byte myMac[] = { 0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xED }; // Set Arduino Ethernet Mac
byte myIp[]  = { 192, 168, 1, 12 }; // Set Arduino Ethernet IP 

byte destIp[] =  { 192, 168, 1, 2 }; // Destination IP
int  destPort = 4444; // Destination Port 

char oscAdr[] =  "/z-osc/di"; // Adress for sending the Digital pins (2,3,5,6,7,8,9)
char oscAdr1[] = "/z-osc/ai"; // Adress for sending the Analog pins (0-5)
//Ethernet shield uses pins 4,10 . 

long int valuePIn2 = 0;     
long int valuePIn3 = 0; 
long int valuePIn5 = 0;
long int valuePIn6 = 0;     
long int valuePIn7 = 0; 
long int valuePIn8 = 0;     
long int valuePIn9 = 0;


long int AnPIn0 = 0;     
long int AnPIn1 = 0; 
long int AnPIn2 = 0;     
long int AnPIn3 = 0;
long int AnPIn4 = 0;     
long int AnPIn5 = 0; 

Z_OSCClient client;

void setup(){
  
 
      pinMode(2, INPUT);
      pinMode(3, INPUT);
      pinMode(5, INPUT);
      pinMode(6, INPUT);
      pinMode(7, INPUT);
      pinMode(8, INPUT);
      pinMode(9, INPUT);
  
  
  Serial.begin(19200);

  Ethernet.begin(myMac ,myIp);  
  
}

void loop(){
  
  Z_OSCMessage mes;  
  
  mes.setAddress(destIp,destPort);
  
  //Digital Pins
  mes.setZ_OSCMessage(oscAdr,"iiiiiii" ,&valuePIn2,&valuePIn3,&valuePIn5,
  &valuePIn6,&valuePIn7,&valuePIn8,&valuePIn9);
  client.send(&mes);
  
  valuePIn2 = digitalRead(2); 
  valuePIn3 = digitalRead(3);
 
  valuePIn5 = digitalRead(5);
  valuePIn6 = digitalRead(6); 
  valuePIn7 = digitalRead(7);
  valuePIn8 = digitalRead(8); 
  valuePIn9 = digitalRead(9);
  
  
  Z_OSCMessage mesanalog;  
  
  mesanalog.setAddress(destIp,destPort);
  
    //Analog Pins
  mesanalog.setZ_OSCMessage(oscAdr1,"iiiiii" ,&AnPIn0,&AnPIn1,&AnPIn2,&AnPIn3,
  &AnPIn4,&AnPIn5);
  client.send(&mesanalog);
  
  AnPIn0= analogRead(0);
  AnPIn1= analogRead(1);
  AnPIn2= analogRead(2);
  AnPIn3= analogRead(3);
  AnPIn4= analogRead(4);
  AnPIn5= analogRead(5);

  //mes.flush();
    
  delay(10);
}


