
//Receive from outside and apply to arduino pins via OSC

//Credits to Jerome Dupraz & Retocama  

//Colorsound 011
// you can download arduino z-osc library from here https://github.com/djiamnot/Z_OSC
// you can download arduino code and vvvv patch from here: http://vvvv.org/contribution/arduinoosc
#include <SPI.h>
#include <Ethernet.h> // Tested in version IDE 0022 Arduino UNO

#include <Z_OSC.h>


byte myMac[] = { 0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xED };
byte myIp[]  = { 192, 168, 1, 12 };
int  serverPort  = 4443;


long int dw2 = 0;  // Variable to set value for Digital pin 2 to digitalWrite 
long int dw7 = 0;


long int pwm3 = 0; // Variable to set value for Digital pin 3 to pwm
long int pwm5 = 0;
long int pwm6 = 0; 

Z_OSCServer server;

Z_OSCMessage *rcvMes;

void setup(){ 
  //Pins 4,10 are used for the Ethernet shield . Adding pins 8 and 9 for use made this code buggy. 
  
  //Set pins as Outputs 
 pinMode(2, OUTPUT);
 pinMode(7, OUTPUT);

 pinMode(3, OUTPUT);
 pinMode(5, OUTPUT);
 pinMode(6, OUTPUT);

  
 Serial.begin(19200);
 
 Ethernet.begin(myMac ,myIp); 
 
 server.sockOpen(serverPort);
   
}
  
void loop(){

 if(server.available()){
   
  rcvMes=server.getMessage();

  //logMessage();
  
  
  
      
      //Pwm Pins
      
      
     //PWM Pin 3 
     if( !strcmp( rcvMes->getZ_OSCAddress() ,  "/arduino/out" ) ) 
     {
      
      pwm3 = rcvMes->getInteger32(0); //Get first value from incoming /arduino/out
      pwm3 = constrain(pwm3, 0, 255); // limit the value to 0-255
      analogWrite(3,pwm3);  // set pwm value on PIN
     }
  
     //PWM Pin 5
     if( !strcmp( rcvMes->getZ_OSCAddress() ,  "/arduino/out" ) ) 
     {
      pwm5 = rcvMes->getInteger32(1);//Get second value from incoming /arduino/out
      pwm5 = constrain(pwm5, 0, 255); // limit the value to 0-255
      analogWrite(5,pwm5);  // set pwm value on PIN
     }
     
      //PWM Pin 6 
     if( !strcmp( rcvMes->getZ_OSCAddress() ,  "/arduino/out" ) ) 
     {
      
      pwm6 = rcvMes->getInteger32(2); //Get first value from incoming /arduino/out
      pwm6 = constrain(pwm6, 0, 255); // limit the value to 0-255
      analogWrite(6,pwm6);  // set pwm value on PIN
     }
  
    
  
  
  //Digital pins 
      
      // Digital Pin 2
      if ( !strcmp( rcvMes->getZ_OSCAddress() ,  "/arduino/out" )) 
      {
        
      dw2 = rcvMes->getInteger32(3); //Get fith value from incoming /arduino/out
      dw2 = constrain(dw2, 0, 1); // limit the value to 0-1
     if ( dw2 == 1 ) {
      digitalWrite(2,HIGH);  // set pwm value on PIN
                     }
      else {
      digitalWrite(2,LOW);
           }
      }   
      
      // Digital Pin 7
     if ( !strcmp( rcvMes->getZ_OSCAddress() ,  "/arduino/out" )) 
      {
        
      dw7 = rcvMes->getInteger32(4); //Get fith value from incoming /arduino/out
      dw7 = constrain(dw7, 0, 1); // limit the value to 0-1
     if ( dw7== 1 ) {
      digitalWrite(7,HIGH);  
                     }
      else {
      digitalWrite(7,LOW);
           }
      }     
      
      
   }
 }
  
  
  //Log maker 
  
void logMessage(){
    uint16_t i;
    byte *ip=rcvMes->getIpAddress();
    
    long int intValue;
    float floatValue;
    char *stringValue;
    
    Serial.print(ip[0],DEC);
    Serial.print(".");
    Serial.print(ip[1],DEC);
    Serial.print(".");
    Serial.print(ip[2],DEC);
    Serial.print(".");
    Serial.print(ip[3],DEC);
    Serial.print(":");
    
    Serial.print(rcvMes->getPortNumber());
    Serial.print(" ");
    Serial.print(rcvMes->getZ_OSCAddress());
    Serial.print(" ");
    Serial.print(rcvMes->getTypeTags());
    Serial.print("--");
    
    for(i=0 ; i<rcvMes->getArgsNum(); i++){
      
     switch( rcvMes->getTypeTag(i) ){
      
        case 'i':       
          intValue = rcvMes->getInteger32(i);
          
          Serial.print(intValue);
          Serial.print(" ");
         break; 
         
         
        case 'f':        
          floatValue = rcvMes->getFloat(i);
        
          Serial.print(floatValue);
          Serial.print(" ");
         break; 
        
        
         case 's':         
          stringValue = rcvMes->getString(i);
         
          Serial.print(stringValue);
          Serial.print(" ");
         break; 
       
     }
    
      
    }
     Serial.println("");
}
