#region usings
using System;
using System.ComponentModel.Composition;
using System.Globalization;
using System.Text.RegularExpressions;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using VVVV.Core.Logging;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "AsAscii", Category = "String Hex", Help = "Hex string to ASCII", Tags = "hex, ascii, base")]
	#endregion PluginInfo
	public class AsAscii : IPluginEvaluate
	{
		#region fields & pins
		[Input("Input", DefaultString = "hello c#")]
		ISpread<string> FInput;

		[Output("Output")]
		ISpread<string> FOutput;

		[Import()]
		ILogger Flogger;
		#endregion fields & pins

		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
			FOutput.SliceCount = SpreadMax;

			for (int i = 0; i < SpreadMax; i++) {
				FOutput[i] = "";
				FInput[i] = Regex.Replace(FInput[i], @"\s", "" );	//whitespace
				for (int j = 0; j < FInput[i].Length; j+=2)
					FOutput[i] += (char)Int32.Parse(FInput[i].Substring(j,2), NumberStyles.AllowHexSpecifier);
			}

			Flogger.Log(LogType.Debug, "Logging to Renderer (TTY)");
		}
	}
}
