#region usings
using System;
using System.ComponentModel.Composition;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using VVVV.Core.Logging;
using System.Collections.Generic;


#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "Greenwich", Category = "Astronomy", Help = "Basic template with one value in/out", Tags = "")]
	#endregion PluginInfo
	public class AstronomyGreenwhichNode : IPluginEvaluate
	{
		#region fields & pins
		[Input("UMT Coordinates", DefaultValue = 1.0)]
		IDiffSpread<Vector2D> FInput;

		[Input("Zone")]
		IDiffSpread<int> FZone;

		[Input("Southern Hemisphere")]
		IDiffSpread<bool> FHemisphere;

		[Output("Angles", DimensionNames = new string[] { "Long", "Lat" } )]
		ISpread<Vector2D> FOutput;
		

		[Import()]
		ILogger FLogger;
		#endregion fields & pins


		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{

			if (!(FInput.IsChanged || FZone.IsChanged || FHemisphere.IsChanged)) return;
			
			GeoUTMConverter converter = new GeoUTMConverter();
			FZone.SliceCount = FHemisphere.SliceCount = FOutput.SliceCount = SpreadMax;

			for (int i = 0; i < SpreadMax; i++) {
				GeoUTMConverter.Hemisphere hemi = FHemisphere[i]?GeoUTMConverter.Hemisphere.Northern:GeoUTMConverter.Hemisphere.Southern;
				
				converter.ToLatLon(FInput[i].x, FInput[i].y, FZone[i], hemi);

				Vector2D v = new Vector2D();
				v.x = converter.Longitude;
				v.y = converter.Latitude;

				FOutput[i] = v;
			}


			//FLogger.Log(LogType.Debug, "hi tty!");
		}
	}	
	#region PluginInfo
	
	
	[PluginInfo(Name = "UTM", Category = "Astronomy", Help = "Basic template with one value in/out", Tags = "")]
	#endregion PluginInfo
	public class AstronomyUTMNode : IPluginEvaluate
	{
		#region fields & pins
		[Input("Angles", DimensionNames = new string[] { "Long", "Lat" } )]
		IDiffSpread<Vector2D> FInput;

		[Output("UMT Coordinates")]
		ISpread<Vector2D> FOutput;

		[Output("Zone")]
		ISpread<int> FZone;

		[Output("Southern Hemisphere")]
		ISpread<bool> FHemisphere;
		
		[Import()]
		ILogger FLogger;
		#endregion fields & pins


		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
			if (!FInput.IsChanged) return;
			
			GeoUTMConverter converter = new GeoUTMConverter();
			FOutput.SliceCount = SpreadMax;

			for (int i = 0; i < SpreadMax; i++) {
				converter.ToUTM(FInput[i].y, FInput[i].x);
				
				Vector2D v = new Vector2D();
				v.x = converter.X;
				v.y = converter.Y;
				FOutput[i] = v;
				
				
				FZone[i] = (int)converter.Zone;
				FHemisphere[i] = FInput[i].y > 0;
			}


			//FLogger.Log(LogType.Debug, "hi tty!");
		}
	}
}
