#region usings
using System;
using System.ComponentModel.Composition;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using VVVV.Core.Logging;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "Boids_Cluster", Category = "Value", Help = "Boids Cluster", Tags = "Catweasel,boids")]
	#endregion PluginInfo
	public class ValueBoids_ClusterNode : IPluginEvaluate
	{
		#region fields & pins
		[Input("Input", DefaultValue = 1.0)]
		ISpread<Vector3D> FInput;
		[Input("Max Radius", DefaultValue = .001)]
		ISpread<double> FMaxRadius;
		[Input("Amount", DefaultValue = 100)]
		ISpread<double> FAmount;
		
		[Output("Output")]
		ISpread<Vector3D> FOutput;
		[Output("Centre")]
		ISpread<Vector3D> FCentre;

		[Import()]
		ILogger FLogger;
		#endregion fields & pins

		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{

			FOutput.SliceCount = SpreadMax;




			for (int i = 0; i < SpreadMax; i++) {
				FOutput[i] = new Vector3D(); //Initialise Output array
				for (int j = 0; j < SpreadMax; j++) {
					if ( VMath.Dist(FInput[i],FInput[j])<FMaxRadius[0] ) //<- Have to use FMaxRadius with a [0] otherwise it a cast mismatch
						FOutput[i] += FInput[j]; // Add all the positions together to find the average
				}
			}
			
			for (int i = 0; i < SpreadMax; i++) {
				FOutput[i] = ((FOutput[i] / (SpreadMax - 1)) - FInput[i]) / FAmount[0];
			}

			FCentre[0] = FOutput[0];

			//FLogger.Log(LogType.Debug, "hi tty!");
		}
	}
}
