#region usings
using System;
using System.ComponentModel.Composition;
using System.Collections.Generic;
using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using VVVV.Core.Logging;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "Boids_Keep_Away", Category = "Value", Help = "Boids Avoid others", Tags = "Catweasel,boids")]
	#endregion PluginInfo
	public class ValueBoids_Keep_AwayNode : IPluginEvaluate
	{
		#region fields & pins
		[Input("Input", DefaultValue = 1.0)]
		ISpread<Vector3D> FInput;
		
		[Input("Max Radius", DefaultValue = .001)]
		ISpread<double> FMaxRadius;
		
		[Output("Output")]
		ISpread<Vector3D> FOutput;
		
List<Vector3D> pv = new List<Vector3D>();
		
		[Import()]
		ILogger FLogger;
		#endregion fields & pins

		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
        {
            FOutput.SliceCount = SpreadMax;
        	
            for (int i = 0; i < SpreadMax; i++)
            {
                
 
            	for (int j = 0; j < SpreadMax; j++)
            	{
            		if (i != j) // if its the same boid dont do it
            		{
            			//then
            			if ( VMath.Dist(FInput[i],FInput[j])<FMaxRadius[0] ) //if I'm within range
            			//then
            			FOutput[i] +=  (FInput[i]-FInput[j]); //then move me away
            			           		
            		}
            	else
            			{
            			FOutput[i]	=FInput[i]; //else do nothing
            			}	
                }
            }
        }




	}
}
