#region usings
using System;
using System.ComponentModel.Composition;
using System.Collections.Generic;
using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using VVVV.Core.Logging;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "Boids_Match_Velocity", Category = "Value", Help = "Boids Match Velocity", Tags = "Catweasel,boids")]
	#endregion PluginInfo
	public class ValueBoids_Match_VelocityNode : IPluginEvaluate
	{
		#region fields & pins
		[Input("Input", DefaultValue = 1.0)]
		ISpread<Vector3D> FInput;
		[Input("Amount", DefaultValue = 8)]
		ISpread<double> FAmount;


		[Output("Output")]
		ISpread<Vector3D> FOutput;



		[Import()]
		ILogger FLogger;
		#endregion fields & pins

		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
			FOutput.SliceCount = SpreadMax;

			for (int i = 0; i < SpreadMax; i++) {
				FOutput[i] = new Vector3D();
							
				FOutput[i] +=  FInput[i] ; //add all the velocities together
				FOutput[i] = FOutput[i]/(SpreadMax-1); //and average them
				FOutput[i] = (FOutput[i]+FInput[i])/FAmount[0]; //add them to the incoming velocity and divide by the amount to tame it all
					
				}
			}
		}
}



