#region usings
using System;
using System.ComponentModel.Composition;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using VVVV.Core.Logging;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "Boids_Move_to_centre", Category = "Value", Help = "Basic template with one value in/out", Tags = "")]
	#endregion PluginInfo
	public class ValueBoids_Move_to_centreNode : IPluginEvaluate
	{
		#region fields & pins
		[Input("Input", DefaultValue = 1.0)]
		ISpread<Vector3D> FInput;

		[Output("Output")]
		ISpread<Vector3D> FOutput;
		[Output("Centre")]
		ISpread<Vector3D> FCentre;

		[Import()]
		ILogger FLogger;
		#endregion fields & pins

		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
	
			FOutput.SliceCount = SpreadMax;

			
			

			for (int i = 0; i < SpreadMax; i++ )
			{
			FOutput[i] = new Vector3D();
				for (int j = 0; j < SpreadMax; j++ )
				{
				if (i != j)
				FOutput[i]+= FInput[j];
				}
			}
			//FOutput= Vector3D operator /(FOutput,Convert.ToDouble(SpreadMax)); //Pcj our flock centre
			
			for (int i = 0; i < SpreadMax; i++ )
			{
			FOutput[i] = ((FOutput[i]/(SpreadMax-1)) - FInput[i])/100 ;
			}
			
			FCentre[0] = FOutput[0];	

			//FLogger.Log(LogType.Debug, "hi tty!");
		}
	}
}
