using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

namespace boids_simulator_xna
{
    /// <summary>
    ///  Used to simulate the movments and behaviour of flocking type
    ///  creature
    /// </summary>
    public class Boid
    {
        private static Random rnd = new Random();
        private static float border = 100f;//kylel need to remove all these hard coded values
        private static float sight = 75f;
        private static float space = 30f;
        private static float speed = 12f;
        private float boundary;
        public float dX;
        public float dY;
        public bool Zombie;
        public Vector2D Position;
        //Texture2D myTexture;


        /// <param name="zombie">Is the boid a zombie</param>
        /// <param name="boundary">Area in which the boid can live</param>
        public Boid(bool zombie, int boundary)
        {
            Position = new Vector2D(rnd.Next(boundary), rnd.Next(boundary));
            this.boundary = boundary;
            Zombie = zombie;
        }



        /// <summary>
        ///  Move within a collection ofother boids
        /// </summary>
        /// <param name="boids">other boids</param>
        public void Move(List<Boid> boids)
        {
            if (!Zombie) Flock(boids);
            else Hunt(boids);
            CheckBounds();
            CheckSpeed();
            Position[0] += dX;
            Position[1] += dY;
        }

        /// <summary>
        ///  Calculate movement as prey to avoid predators and follow the flock
        /// </summary>
        /// <param name="boids">other boids</param>
        private void Flock(List<Boid> boids)
        {
            foreach (Boid boid in boids)
            {
                float distance = Distance(Position, boid.Position);
                if (boid != this && !boid.Zombie)
                {
                    if (distance < space)
                    {
                        // Create space.
                        dX += Position[0] - boid.Position[0];
                        dY += Position[1] - boid.Position[1];
                    }
                    else if (distance < sight)
                    {
                        // Flock together.
                        dX += (boid.Position[0] - Position[0]) * 0.05f;
                        dY += (boid.Position[1] - Position[1]) * 0.05f;
                    }
                    if (distance < sight)
                    {
                        // Align movement.
                        dX += boid.dX * 0.5f;
                        dY += boid.dY * 0.5f;
                    }
                }

                if (boid.Zombie && distance < sight)
                {
                    // Avoid zombies.
                    dX += Position[0] - boid.Position[0];
                    dY += Position[1] - boid.Position[1];
                }
            }
        }

        /// <summary>
        ///  Calculate movement as predator find prey. No flocking behaviour!
        /// </summary>
        /// <param name="boids">other boids</param>
        private void Hunt(List<Boid> boids)
        {
            float range = float.MaxValue;
            Boid prey = null;
            foreach (Boid boid in boids)
            {
                if (!boid.Zombie)
                {
                    float distance = Distance(Position, boid.Position);
                    if (distance < sight && distance < range)
                    {
                        range = distance;
                        prey = boid;
                    }
                }
            }

            if (prey != null)
            {
                // Move towards closest prey.
                dX += prey.Position[0] - Position[0];
                dY += prey.Position[1] - Position[1];
            }
        }

        /// <summary>
        ///  Calculate distance between two points
        /// </summary>
        /// <param name="p1">point 1</param>
        /// <param name="p2">point 2</param>
        private static float Distance(Vector2D p1, Vector2D p2)
        {
            double val = Math.Pow(p1[0] - p2[0], 2) + Math.Pow(p1[1] - p2[1], 2);
            return (float)Math.Sqrt(val);
        }

        /// <summary>
        ///  check bounds
        /// </summary>
        private void CheckBounds()
        {
            float val = boundary - border;
            if (Position[0] < border) dX += border - Position[0];
            if (Position[1] < border) dY += border - Position[1];
            if (Position[0] > val) dX += val - Position[0];
            if (Position[1] > val) dY += val - Position[1];
        }

        /// <summary>
        ///  check speed
        /// </summary>
        private void CheckSpeed()
        {
            float s;
            if (!Zombie) s = speed;
            else s = speed / 4f;
            float val = Distance(new Vector2D(0f, 0f), new Vector2D(dX, dY));
            if (val > s)
            {
                dX = dX * s / val;
                dY = dY * s / val;
            }
        }
    }
}