Texture2D texA <string uiname="Texture A";>;
Texture2D texB <string uiname="Texture B";>;

Texture2D texPAPER <string uiname="Paper Texture";>;
TextureCube texREFL <string uiname="Reflection Texture";>;

SamplerState s0:IMMUTABLE
{Filter=MIN_MAG_MIP_LINEAR;AddressU=CLAMP;AddressV=CLAMP;};

SamplerState sA:IMMUTABLE
{Filter=ANISOTROPIC;AddressU=CLAMP;AddressV=CLAMP;};

cbuffer cbControls:register(b0){
	float4x4 tW:WORLD;
	float4x4 tV:VIEW;
	float4x4 tP:PROJECTION;
	float4x4 tWI:WORLDINVERSE;
	float4x4 tVI:VIEWINVERSE;
	float4x4 tPI:PROJECTIONINVERSE;
	float4x4 tWIT:WORLDINVERSETRANSPOSE;
	
	//float Alpha <float uimin=0.0; float uimax=1.0;> = 1; 
	float4 Color <bool color=true;> = {1.0,1.0,1.0,1.0};
	float4 ReflectionColor <bool color=true;> = {0.0,0.0,0.0,1.0};
	float4x4 tTex <string uiname="Texture Transform";>;
	float4x4 tTexA;
	float4x4 tTexB;
	
};


struct VS_IN{
	float4 PosO:POSITION;
	float4 TexCd:TEXCOORD0;
	float3 Norm:NORMAL0;
	
};

struct VS_OUT{
	float4 PosWVP:SV_POSITION;
	float4 TexCd:TEXCOORD0;
	float4 PosW:TEXCOORD1;
	float3 Norm:NORMAL0;
	
};
float TurnPosition <float uimin=0.0; float uimax=1.0;> = 0; 
float TurnVelocity = 0; 
float Angle <float uimin=0.0; float uimax=1.0;> =0.5;
float Distort=1;
float Shadow <float uimin=0.0; float uimax=1.0;> =0.1;
float ScaleFactor <float uimin=0.0;> =1;
float2 r2d(float2 x,float a){a*=acos(-1)*2;return float2(cos(a)*x.x+sin(a)*x.y,cos(a)*x.y-sin(a)*x.x);}
float3x3 lookat(float3 dir,float3 up=float3(0,1,0)){float3 z=normalize(dir);float3 x=normalize(cross(up,z));float3 y=normalize(cross(z,x));return float3x3(x,y,z);} 

float3 dist(float3 pos){
	float3 p=pos;
	p.x+=.5;
	p.x*=ScaleFactor;
	p.xz=r2d(p.xz,pow(saturate(TurnPosition),pow(2,Distort*TurnVelocity*pow(length(pos.xy-float2(.5,Angle-0.5)),2)))*0.5);
	return p;
}

float eps <string uiname="Epsilon";> =0.01;


float3 distnorm(inout float3 pos,float3 n,float eps){
	n+=.0001;
	float3x3 lkt=lookat(n);
	
	float3 v1=float3(1,0,0);
	float3 v2=float3(0,0,1);
	
	v1=normalize(mul(v1,(lkt)));
	v2=normalize(cross(n,v1));
	
	float3 p0=pos.xyz;
	float3 p1=p0+v1*eps;
	float3 p2=p0+v2*eps;
	//float3 p3=p0-v1*eps;
	//float3 p4=p0-v2*eps;
	
	p0=dist(p0);
	p1=dist(p1);
	p2=dist(p2);
	//p3=dist(p4);
	//p4=dist(p4);
	
	
	v1=normalize(p1-p0);
	v2=normalize(p2-p0);
	pos.xyz=p0;
	return normalize(cross(v1,v2));
}

VS_OUT VS(VS_IN In){
	VS_OUT Out=(VS_OUT)0;
	float4 PosW=In.PosO;
	//PosW.xyz=dist(In.PosO.xyz);
	Out.Norm=In.Norm;
	Out.Norm=distnorm(PosW.xyz,In.Norm,eps);
	PosW=mul(PosW,tW);
	Out.PosW=PosW;
	Out.Norm=mul(Out.Norm,(float3x3)tWIT);
	
	
	Out.PosWVP=mul(PosW,mul(tV,tP));
	Out.TexCd=mul(In.TexCd,tTex);
	return Out;
}


float4 PS(VS_OUT In,bool ff:SV_IsFrontFace):SV_Target{
	
	float4 cPaper=texPAPER.Sample(sA,In.TexCd.xy);
	float2 uv=In.TexCd.xy;
	uv=mul(float4((uv.xy*2-1)*float2(1,-1),0,1),tTexA).xy*float2(1,-1)*.5+.5;

	float4 cTex=texA.Sample(sA,uv);
	if(!ff){
		uv=float2(1-In.TexCd.x,In.TexCd.y);
		uv=mul(float4((uv.xy*2-1)*float2(1,-1),0,1),tTexB).xy*float2(1,-1)*.5+.5;
		cTex=texB.Sample(sA,uv);
		In.Norm*=-1;
	}
	float4 c=cTex;
	
	
	float3 View=normalize(In.PosW.xyz-tVI[3].xyz);
	float g=saturate(-dot(View,In.Norm));
	float3 vRef=normalize(reflect(View,In.Norm));

	c=c*Color;
	//c.rgb=In.Norm*.5+.5;
	//c.rgb*=g;
	c.rgb+=pow(saturate(In.TexCd.x),.5)*(ReflectionColor*(1-g*.8)*texREFL.Sample(s0,vRef)).rgb;
	c.rgb*=pow(g*.9+.1,.5);
	c=lerp(c,cTex*Color,smoothstep(.45,.5,abs(TurnPosition-0.5)));
	if(c.a<=1./255.)discard;
	c.rgb*=pow(saturate(1-pow(saturate(1-In.TexCd.x),pow(1./Shadow,2))),pow(saturate(Shadow),.6));

	c*=cPaper;
	
	//c.rgb=g;
	//c.a=Alpha;
	return c;
}


technique10 Basic{
	pass P0{
		SetVertexShader(CompileShader(vs_5_0,VS()));
		SetPixelShader(CompileShader(ps_5_0,PS()));
	}
}




