//@author: vux
//@help: template for standard shaders
//@tags: template
//@credits: 


// --------------------------------------------------------------------------------------------------
// PARAMETERS:
// --------------------------------------------------------------------------------------------------


//transforms
float4x4 tW: WORLD ;        //the models world matrix
float4x4 tV: VIEW ;         //view matrix as set via Renderer (EX9)
float4x4 tP: PROJECTION ;
float4x4 tWVP: WORLDVIEWPROJECTION ;
float4x4 tVIT : VIEWINVERSETRANSPOSE ; 
float4x4 tVP : VIEWPROJECTION ;



Texture2D normalMap <string uiname="NormalMap";>;
Texture2D microflakeNMap <string uiname="microflakeNMap";>;
TextureCube showroomMap <string uiname="showroomMap";>;

SamplerState g_samLinear
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
};



SamplerState showroomMapSamp : IMMUTABLE   
{
    Texture   = (showroomMap);  
	AddressU = Clamp;
    AddressV = Clamp;
    AddressW = Clamp;
     Filter = MIN_MAG_MIP_LINEAR;
	MIPLODBIAS = 0.000000;
};
float4x4 tTex <bool uvspace=true; string uiname="Texture Transform";>;
//float4x4 tTex: TEXTUREMATRIX <string uiname="Texture Transform";>;
float4 paintColorMid  <bool color = true;  String uiname="paintColorMid";>  = {0.6, 0.0, 0.0, 0.0};
float4 paintColor2 <bool color = true; String uiname="paintColor2";>  = {0.0, 0.35, -0.35, 0.0 };
float4 paintColor0 <bool color = true; String uiname="paintColor0";>  = {0.4, 0.0, 0.349, 0.0};
float4 flakeLayerColor <bool color = true; String uiname="flakeLayerColor";>  = {0.5, 0.5, 0.0, 0.0};


float normalPerturbation = {1.0};
float microflakePerturbationA = {0.1};
float microflakePerturbation = {1.0} ;
float brightnessFactor = {8.0};
float glossLevel = {0.0};
 
struct VS_IN
{
	float4 PosO     : POSITION; 
    float3 Normal   : NORMAL;
    float2 TexCd    : TEXCOORD0;
    float3 Tangent  : TANGENT;
    float3 Binormal : BINORMAL;

};

struct vs2ps
{
   float4 Pos        : SV_POSITION;
   float2 TexCd      : TEXCOORD0;
   float3 Tangent    : TEXCOORD1;
   float3 Binormal   : TEXCOORD2;
   float3 Normal     : NORMAL;
   float3 View       : TEXCOORD4;
   float4 SparkleTex : TEXCOORD5;
};

vs2ps VS(VS_IN input)
{
   vs2ps Out;
   Out.Pos = mul(input.PosO, tWVP); 
  Out.TexCd = mul(float4(input.TexCd, 0, 1), tTex).xy;
	//Out.TexCd = input.TexCd;
   Out.View = normalize( mul(tVIT, float4( 0, 0, 0, 1)) - input.PosO ).xyz;
   Out.TexCd.y  = 1 - Out.TexCd.y ; 
   Out.Normal   = input.Normal;
   Out.Tangent  = input.Tangent;
   Out.Binormal = -input.Binormal;
	//Out.Tangent  = normalize( mul(float4(input.Tangent, 1), tW)).xyz;
	//pOut.Binormal  =   normalize( mul(float4(input.Binormal, 1), tW)).xyz;
   Out.SparkleTex = float4( Out.TexCd * 20.0, 0, 1);
	
   return Out;
}




float4 PS(vs2ps In): SV_Target
{
   
	
   float3 vNormal = normalMap.Sample(g_samLinear, In.TexCd).rgb;
   vNormal = (2 * vNormal - 1.0) * 1;
   float3 vFlakesNormal = microflakeNMap.Sample(g_samLinear, In.SparkleTex).rgb;
   vFlakesNormal = 2 * vFlakesNormal - 1.0;
   float3 vNp1 = microflakePerturbationA * vFlakesNormal + normalPerturbation * vNormal ; 
   float3 vNp2 = microflakePerturbation * ( vFlakesNormal + vNormal ) ;
   float3 vView =  normalize( In.View );
   float3x3 mTangentToWorld = transpose( float3x3( In.Tangent, In.Binormal, In.Normal ) );
   float3   vNormalWorld    = normalize( mul( mTangentToWorld, vNormal ));
   float  fNdotV     = saturate(dot( vNormalWorld, vView));
   float3 vReflection = 2 * vNormalWorld * fNdotV - vView;
   float fEnvBias = glossLevel;
   float4 envMap = showroomMap.Sample(showroomMapSamp, vReflection);
   envMap.rgb = envMap.rgb * envMap.a;
   envMap.rgb *= brightnessFactor;
   float3 vNp1World = normalize( mul( mTangentToWorld, vNp1) );
   float  fFresnel1 = saturate( dot( vNp1World, vView ));
   float3 vNp2World = normalize( mul( mTangentToWorld, vNp2 ));
   float  fFresnel2 = saturate( dot( vNp2World, vView ));   
   float  fFresnel1Sq = fFresnel1 * fFresnel1;

   float4 paintColor = fFresnel1   * paintColor0 + 
              fFresnel1Sq * paintColorMid +
              fFresnel1Sq * fFresnel1Sq * paintColor2 +
              pow( fFresnel2, 16 ) * flakeLayerColor;
   float  fEnvContribution = 1.0 - 0.5 * fNdotV;

   float4 finalColor;
   finalColor.a = 1.0;
   finalColor.rgb = envMap.rgb * fEnvContribution + paintColor.rgb;
   return finalColor;
	
	
}





technique10 Constant
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, PS() ) );
	}
}




