float4x4 tW: World;
float4x4 Vw: View;
float4x4 Pj: Projection;

//texture var
texture tex;

//mouse pos
float2 mousePosition;

//light globals
float3 LightPosition;
float3 ConeDirection;
float LightStrength;
float ConeAngle;
float ConeDecay;
float Ambient;

sampler ColoredTextureSampler = sampler_state
{
	texture = <tex>;
	magfilter = LINEAR;
	minfilter = LINEAR;
	mipfilter = LINEAR;
	AddressU = mirror;
	AddressV = mirror;
};

/******************************* light structs/shaders ********************/
struct SL_VS
{
	float4 Position : POSITION0;
	float3 Normal : TEXCOORD0;
	float3 LightDirection : TEXCOORD1;
};

struct SL_PS
{
	float4 Color : COLOR0;
};

SL_VS L_VertexShaderFunction ( float4 inPos: POSITION0, float3 inNormal: NORMAL0 )
{
	SL_VS output = (SL_VS)0;
	
	float4x4 preVP = mul ( Vw, Pj );
	float4x4 preWVP = mul ( tW, preVP );
	output.Position = mul ( inPos, preWVP );
	
	float3 finalPos = mul ( inPos, tW );
	output.LightDirection = finalPos - LightPosition;
	
	float3x3 rotMax = (float3x3)tW;
	float3 rotNorm = mul ( inNormal, rotMax );
	output.Normal = rotNorm;
	
	return output;
}

float4 L_PixelShaderFunction ( SL_VS input ) : COLOR0
{
	float4 output = tex2D ( ColoredTextureSampler, mousePosition );
	
	float4 baseColor = float4 ( 0, 0, 1, 1 );
	
	float3 normal = normalize ( input.Normal );
	float3 lightDir = normalize ( input.LightDirection );
	
	float coneDot = dot ( lightDir, normalize ( ConeDirection ) );
	float shading = 0;
	
	if ( coneDot > ConeAngle )
	{
		float coneAtten = pow ( coneDot, ConeDecay );
		shading = dot ( normal, -lightDir );
		shading *= LightStrength;
		shading *= coneAtten;
	}
//	output.Color = baseColor * (shading + Ambient );
	
	return output;
}
/******************************* end light structs/shaders ****************/

technique TSimpleShader
{
    pass P0
    {
        VertexShader = compile vs_1_0 L_VertexShaderFunction();
        PixelShader  = compile ps_3_0 L_PixelShaderFunction();
    }
}
