//@author: vvvv group
//@help: draws a mesh with a constant color
//@tags: simple, template, basic
//@credits:

// --------------------------------------------------------------------------------------------------
// PARAMETERS:
// --------------------------------------------------------------------------------------------------

//transforms
float4x4 tW: WORLD;        //the models world matrix
float4x4 tV: VIEW;         //view matrix as set via Renderer (EX9)
float4x4 tP: PROJECTION;   //projection matrix as set via Renderer (EX9)
float4x4 tWVP: WORLDVIEWPROJECTION;

//material properties
float4 cAmb : COLOR <String uiname="Color";>  = {1, 1, 1, 1};
float Alpha1 <float uimin=0.0; float uimax=1.0;> = 1;
float Alpha2 <float uimin=0.0; float uimax=1.0;> = 1;
float Alpha3 <float uimin=0.0; float uimax=1.0;> = 1;
float Alpha4 <float uimin=0.0; float uimax=1.0;> = 1;
float Alpha5 <float uimin=0.0; float uimax=1.0;> = 1;
float Alpha6 <float uimin=0.0; float uimax=1.0;> = 1;
//texture
texture Tex1 <string uiname="Texture1";>;
sampler Samp1 = sampler_state    //sampler for doing the texture-lookup
{
    Texture   = (Tex1);          //apply a texture to the sampler
    MipFilter = LINEAR;         //sampler states
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
};
texture Tex2 <string uiname="Texture2";>;
sampler Samp2 = sampler_state    //sampler for doing the texture-lookup
{
    Texture   = (Tex2);          //apply a texture to the sampler
    MipFilter = LINEAR;         //sampler states
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
};
texture Tex3 <string uiname="Texture3";>;
sampler Samp3 = sampler_state    //sampler for doing the texture-lookup
{
    Texture   = (Tex3);          //apply a texture to the sampler
    MipFilter = LINEAR;         //sampler states
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
};
texture Tex4 <string uiname="Texture4";>;
sampler Samp4 = sampler_state    //sampler for doing the texture-lookup
{
    Texture   = (Tex4);          //apply a texture to the sampler
    MipFilter = LINEAR;         //sampler states
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
};
texture Tex5 <string uiname="Texture5";>;
sampler Samp5 = sampler_state    //sampler for doing the texture-lookup
{
    Texture   = (Tex5);          //apply a texture to the sampler
    MipFilter = LINEAR;         //sampler states
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
};

float4x4 tTex: TEXTUREMATRIX <string uiname="Texture Transform";>;
float4x4 tTex2: TEXTUREMATRIX <string uiname="Texture Transform2";>;
float4x4 tTex3: TEXTUREMATRIX <string uiname="Texture Transform3";>;
float4x4 tTex4: TEXTUREMATRIX <string uiname="Texture Transform4";>;
float4x4 tTex5: TEXTUREMATRIX <string uiname="Texture Transform5";>;

float4x4 tCol1 <string uiname="Color Transform1";>;
float4x4 tCol2 <string uiname="Color Transform2";>;
float4x4 tCol3 <string uiname="Color Transform3";>;
float4x4 tCol4 <string uiname="Color Transform4";>;
float4x4 tCol5 <string uiname="Color Transform5";>;

//the data structure: vertexshader to pixelshader
//used as output data with the VS function
//and as input data with the PS function
struct vs2ps
{
    float4 Pos : POSITION;
    float4 TexCd : TEXCOORD0;
};

// --------------------------------------------------------------------------------------------------
// VERTEXSHADERS
// --------------------------------------------------------------------------------------------------

vs2ps VS(
    float4 Pos : POSITION,
    float4 TexCd : TEXCOORD0)
{
    //inititalize all fields of output struct with 0
    vs2ps Out = (vs2ps)0;

    //transform position
    Out.Pos = mul(Pos, tWVP);

    //transform texturecoordinates
    Out.TexCd = mul(TexCd, tTex);

    return Out;
}

// --------------------------------------------------------------------------------------------------
// PIXELSHADERS:
// --------------------------------------------------------------------------------------------------

float4 PS(vs2ps In): COLOR
{
    //In.TexCd = In.TexCd / In.TexCd.w; // for perpective texture projections (e.g. shadow maps) ps_2_0

    float4 col1 = mul(tex2D(Samp1, In.TexCd) * cAmb*Alpha1, tCol1);
	//col1 = mul(col1, tCol1);
    float4 col2 = mul(tex2D(Samp2, In.TexCd) * cAmb*Alpha2, tCol2);
	float4 col3 = mul(tex2D(Samp3, In.TexCd) * cAmb*Alpha3, tCol3);
	float4 col4 = mul(tex2D(Samp4, In.TexCd) * cAmb*Alpha4, tCol4);
	float4 col5 = mul(tex2D(Samp5, In.TexCd) * cAmb*Alpha5, tCol5);
	col1=col1+col2+col3+col4+col5;
	//col = mul(col, tCol);
    

    return col1;
}

// --------------------------------------------------------------------------------------------------
// TECHNIQUES:
// --------------------------------------------------------------------------------------------------

technique TConstant
{
    pass P0
    {
        //Wrap0 = U;  // useful when mesh is round like a sphere
        VertexShader = compile vs_1_1 VS();
        PixelShader = compile ps_2_0 PS();
    }
}

