//@author: vvvv group
//@help: this is a very basic template. use it to start writing your own effects. if you want effects with lighting start from one of the GouraudXXXX or PhongXXXX effects
//@tags:
//@credits:

// --------------------------------------------------------------------------------------------------
// PARAMETERS:
// -----------------------------------------------oooo
float4x4 tW: WORLD;        //the models world matrix
float4x4 tV: VIEW;         //view matrix as set via Renderer (EX9)
float4x4 tP: PROJECTION;
float4x4 tWVP: WORLDVIEWPROJECTION;
float4x4 tProjector;
float4x4 tCol <string uiname="Color Transform";>;

float yBlend_Top=1;
float yBlend_Bot=-1;
float xBlend_Left=-1;
float xBlend_Right=1;
float blendWidth=0.1;
float3 gammaRGB=1;
float4 cAmb : COLOR <String uiname="Color";>  = {1, 1, 1, 1};
//viewports
int ViewIndex: VIEWPORTINDEX;
int ViewCount: VIEWPORTCOUNT;
int ViewIndexIN;

//alpha
float Alpha <float uimin=0.0; float uimax=1.0;> = 1;

//texture
texture Tex <string uiname="Texture";>;
sampler Samp = sampler_state    //sampler for doing the texture-lookup
{
    Texture   = (Tex);          //apply a texture to the sampler
    MipFilter = LINEAR;         //sampler states
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};


//texture transformation marked with semantic TEXTUREMATRIX to achieve symmetric transformations
float4x4 tTex: TEXTUREMATRIX <string uiname="Texture Transform";>;

//the data structure: "vertexshader to pixelshader"
//used as output data with the VS function
//and as input data with the PS function
struct vs2ps
{
    float4 Pos  : POSITION;
    float2 TexCd : TEXCOORD0;
	 float4 PosW : TEXCOORD1;
};

// --------------------------------------------------------------------------------------------------
// VERTEXSHADERS
// --------------------------------------------------------------------------------------------------
vs2ps VS(
    float4 PosO  : POSITION,
    float4 TexCd : TEXCOORD0)
{
    //declare output struct
    vs2ps Out= (vs2ps)0;

    //transform position
	PosO.xyz*=(ViewIndexIN==ViewIndex);//Make it visible within view port by scaling to 0 if not. Watch Spreaded objects...
       Out.Pos = mul(PosO, tWVP);
    float4 PosW = mul(PosO, tW);
 
    //transform texturecoordinates
  //  Out.TexCd = mul(TexCd, tTex);
Out.TexCd = mul(PosW, tProjector);
	
	  Out.PosW = mul(PosO, tW);
    return Out;
}

// --------------------------------------------------------------------------------------------------
// PIXELSHADERS:
// --------------------------------------------------------------------------------------------------
float3 factorY(float pos)
{
    float yTop = yBlend_Bot;
    float yBase = yBlend_Top;

    float factortop = smoothstep(yTop-blendWidth/2,
                                 yTop+blendWidth/2,
                                 pos);
float factorbottom = 1-smoothstep(yBase-blendWidth/2,
                                 yBase+blendWidth/2,
                                 pos);
 return pow(factortop * factorbottom, gammaRGB);
}
// --------------------------------------------------------------------------------------------------
float3 factorX(float pos)
{
 float xTop = xBlend_Left;
    float xBase = xBlend_Right;

    float factortopX = smoothstep(xTop-blendWidth/2,
                                 xTop+blendWidth/2,
                                 pos);
   float factorbottomX = 1-smoothstep(xBase-blendWidth/2,
                                 xBase+blendWidth/2,
                                 pos);
    return pow(factortopX * factorbottomX, gammaRGB);
}
// --------------------------------------------------------------------------------------------------
float4 PS(vs2ps In): COLOR
{
    float4 col = tex2D(Samp, In.TexCd)* cAmb;
	col = mul(col, tCol);
	 col.rgb *= factorY(In.PosW.y);
   col.rgb *= factorX(In.PosW.x);
	//col = mul(col, tCol);
	col.a *= Alpha;
    return col;
}

// --------------------------------------------------------------------------------------------------
// TECHNIQUES:
// --------------------------------------------------------------------------------------------------

technique TSimpleShader
{
    pass P0
    {
        //Wrap0 = U;  // useful when mesh is round like a sphere
        VertexShader = compile vs_3_0 VS();
        PixelShader  = compile ps_3_0 PS();
    }
}