//@author: vvvv group
//@help: draws a mesh with a constant color
//@tags: simple, template, basic
//@credits:

// --------------------------------------------------------------------------------------------------
// PARAMETERS:
// --------------------------------------------------------------------------------------------------

//transforms
float4x4 tW: WORLD;        //the models world matrix
float4x4 tV: VIEW;         //view matrix as set via Renderer (EX9)
float4x4 tP: PROJECTION;   //projection matrix as set via Renderer (EX9)
float4x4 tWVP: WORLDVIEWPROJECTION;

float yBlend_Top=1;
float yBlend_Bot=-1;
float xBlend_Left=-1;
float xBlend_Right=1;
float blendWidth=0.1;
float3 gammaRGB=1;

int ViewIndex: VIEWPORTINDEX;
int ViewCount: VIEWPORTCOUNT;
int ViewIndexIN;

//material properties
float4 cAmb : COLOR <String uiname="Color";>  = {1, 1, 1, 1};
float Alpha <float uimin=0.0; float uimax=1.0;> = 1;

//texture
texture Tex <string uiname="Texture";>;
sampler Samp = sampler_state    //sampler for doing the texture-lookup
{
    Texture   = (Tex);          //apply a texture to the sampler
    MipFilter = LINEAR;         //sampler states
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
};

float4x4 tTex: TEXTUREMATRIX <string uiname="Texture Transform";>;

float4x4 tCol <string uiname="Color Transform";>;

//the data structure: vertexshader to pixelshader
//used as output data with the VS function
//and as input data with the PS function
struct vs2ps
{
    float4 Pos : POSITION;
    float4 TexCd : TEXCOORD0;
	float4 PosW : TEXCOORD1;
};

// --------------------------------------------------------------------------------------------------
// VERTEXSHADERS
// --------------------------------------------------------------------------------------------------

vs2ps VS(
    float4 Pos : POSITION,
    float4 TexCd : TEXCOORD0)
{
    //inititalize all fields of output struct with 0
    vs2ps Out = (vs2ps)0;
Pos.xyz*=(ViewIndexIN==ViewIndex);
    //transform position
    Out.Pos = mul(Pos, tWVP);
float4 PosW = mul(Pos, tW);
    //transform texturecoordinates
    Out.TexCd = mul(TexCd, tTex);
Out.PosW = mul(Pos, tW);
    return Out;
}

// --------------------------------------------------------------------------------------------------
// PIXELSHADERS:
// --------------------------------------------------------------------------------------------------
float3 factorY(float pos)
{
    float yTop = yBlend_Bot;
    float yBase = yBlend_Top;

    float factortop = smoothstep(yTop-blendWidth/2,
                                 yTop+blendWidth/2,
                                 pos);
float factorbottom = 1-smoothstep(yBase-blendWidth/2,
                                 yBase+blendWidth/2,
                                 pos);
 return pow(factortop * factorbottom, gammaRGB);
}
// --------------------------------------------------------------------------------------------------
float3 factorX(float pos)
{
 float xTop = xBlend_Left;
    float xBase = xBlend_Right;

    float factortopX = smoothstep(xTop-blendWidth/2,
                                 xTop+blendWidth/2,
                                 pos);
   float factorbottomX = 1-smoothstep(xBase-blendWidth/2,
                                 xBase+blendWidth/2,
                                 pos);
    return pow(factortopX * factorbottomX, gammaRGB);
}
// --------------------------------------------------------------------------------------------------
float4 PS(vs2ps In): COLOR
{
    //In.TexCd = In.TexCd / In.TexCd.w; // for perpective texture projections (e.g. shadow maps) ps_2_0

    float4 col = tex2D(Samp, In.TexCd);
   col.rgb *= factorY(In.PosW.y);
   col.rgb *= factorX(In.PosW.x);

    return col;
}

// --------------------------------------------------------------------------------------------------
// TECHNIQUES:
// --------------------------------------------------------------------------------------------------

technique TConstant
{
    pass P0
    {
        //Wrap0 = U;  // useful when mesh is round like a sphere
        VertexShader = compile vs_3_0 VS();
        PixelShader = compile ps_3_0 PS();
    }
}

