#region usings
using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using VVVV.Core.Logging;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "Mosaic", Category = "2d", Author = "fibo", Help = "Fractal mosaic", Tags = "fractal,2d")]
	#endregion PluginInfo
	public class C2dMosaic : IPluginEvaluate
	{
		#region fields & pins
		private int recurse = 0;
		private double probability = 1;
		private Random random = new Random();
		
		[Input("Pattern ")]
		IDiffSpread<Vector3D> FInput;

        [Input("Probability", DefaultValue = 1, MinValue = 0, MaxValue = 1, StepSize = 0.01, IsSingle = true)]
        IDiffSpread<double> FProbability;
		
        [Input("Interactions", DefaultValue = 1, MinValue = 1, StepSize = 1, IsSingle = true, AsInt = true)]
        IDiffSpread<int> FInteractions;

		[Output("Output ")]
		ISpread<Vector3D> FOutput;

		[Import()]
		ILogger FLogger;
		#endregion fields & pins
       
		
		/// <summary>
        /// One iteration
        /// </summary>
        /// <param name="points"></param>
        protected List<Vector3D> Iteration(List<Vector3D> points,List<Vector3D> pattern,List<bool> isleafIn)
        {
            try
            {	
                List<Vector3D> outputPoints = new List<Vector3D>();
            	List<bool> isleafOut = new List<bool>();
            	
            	for(int i = 0;i<points.Count;i++)
            	{
            		if(isleafIn[i])
            		{
            			outputPoints.Add(points[i]);
            			isleafOut.Add(true);
            		}
            		else
            		{
            			for(int j = 0;j<pattern.Count;j++)
            			{
            				Vector3D newPoint = new Vector3D(points[i].x+pattern[j].x*points[i].z,points[i].y+pattern[j].y*points[i].z,points[i].z*pattern[j].z);
            				outputPoints.Add(newPoint);
            				
            				double rr = random.NextDouble();
            				if(rr<probability)
            				{
								isleafOut.Add(false);            					
            				}
            				else
            				{
            					isleafOut.Add(true);	
            				}
            			}
            		}
            	}
            	
            	recurse--;
                if (recurse > 0)
                    outputPoints = Iteration(outputPoints,pattern,isleafOut);
            	
                return outputPoints;
            }
            catch (Exception ex)
            {
                //Flogger.Log(LogType.Debug, "Iteration error: " + ex.Message);
                return null;
            }
        }

		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
            if (FInteractions.IsChanged || FInput.IsChanged || FProbability.IsChanged)
            {
                if (FInput.SliceCount == 0) return;
            
            	// every 3d vector (x,y,s) represent a 2d point x,y and a scale factor s
                List<Vector3D> inputPoints = new List<Vector3D>();
                /// copy inputs points to list
            	for(int i = 0;i<FInput.SliceCount;i++)
                	inputPoints.Add(FInput[i]);
            
            	recurse = FInteractions[0];
            	probability = FProbability[0];

            	// start from origin (0,0) with scale = 1
            	List<Vector3D> startingPoint = new List<Vector3D>();
            	startingPoint.Add(new Vector3D(0,0,1));
            	
            	List<bool> isLeaf = new List<bool>();
            	isLeaf.Add(false);
            	
                List<Vector3D> outputPoints = Iteration(startingPoint,inputPoints,isLeaf);
                if (outputPoints == null) return;
                FOutput.SliceCount = outputPoints.Count;
                for (int i = 0; i < outputPoints.Count; i++)
                    FOutput[i] = outputPoints[i];

            }
			//FLogger.Log(LogType.Debug, "hi tty!");
		}
	}
}
