#region usings
using System;
using System.ComponentModel.Composition;
using Microsoft.DirectX;
using Microsoft.DirectX.DirectInput;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using VVVV.Core.Logging;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "Mouse", Category = "DirectInput", Version = "1.0", Help = "Access mouse data using DirectInput", Tags = "")]
	#endregion PluginInfo
	public class C1_0DirectInputMouseNode : IPluginEvaluate
	{
		#region fields & pins
		/*[Input("Foreground", DefaultValue = 0, IsSingle = true)]
		ISpread<bool> FFrg;
		[Input("Exclusive", DefaultValue = 0, IsSingle = true)]
		ISpread<bool> FExclusive;
		[Input("Absolute", DefaultValue = 0, IsSingle = true)]
		ISpread<bool> FAbs;*/
		[Input("Reinitialize", DefaultValue = 0, IsSingle = true)]
		ISpread<bool> FInit;

		[Output("Position XYW")]
		ISpread<int> FPos;
		[Output("Buttons")]
		ISpread<bool> FButton;

		[Import()]
		ILogger FLogger;
		#endregion fields & pins
		
		private Device mouse;
		
		private void InitDevice() {
			mouse = new Device(SystemGuid.Mouse);
			if (mouse == null) FLogger.Log(LogType.Debug, "No mouse found.");
			/*if(FFrg[0] && (!FExclusive[0])) {
				mouse.SetCooperativeLevel(
					this,
					CooperativeLevelFlags.NonExclusive |
					CooperativeLevelFlags.Foreground
				);
			}
			if(FFrg[0] && FExclusive[0]) {
				mouse.SetCooperativeLevel(
					this,
					CooperativeLevelFlags.Exclusive |
					CooperativeLevelFlags.Foreground
				);
			}
			if(!FFrg[0]) {
				mouse.SetCooperativeLevel(
					this,
					CooperativeLevelFlags.NonExclusive |
					CooperativeLevelFlags.Background
				);
			}*/
			mouse.Acquire();
		}
		
		[ImportingConstructor]
		public C1_0DirectInputMouseNode() {
			mouse = new Device(SystemGuid.Mouse);
			mouse.Properties.AxisModeAbsolute = false;
			mouse.Acquire();
		}
		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
			if(FInit[0]) InitDevice();
			if(mouse == null) FLogger.Log(LogType.Debug, "No mouse found.");
			MouseState state = mouse.CurrentMouseState;
			FPos.SliceCount = 3;
			FPos[0] = state.X;
			FPos[1] = state.Y;
			FPos[2] = state.Z;
			
			byte[] buttons = state.GetMouseButtons();
			FButton.SliceCount = buttons.Length;
			for(int i=0; i < buttons.Length; i++) {
				FButton[i] = buttons[i]!=0;
			}
		}
	}
}
