//@author: vux
//@help: standard constant shader
//@tags: color
//@credits: 

Texture3D fakecube <string uiname="Fake Cubemap";>;
SamplerState volumeSampler
{
	Filter = MIN_MAG_MIP_LINEAR;
	AddressU = Clamp;
	AddressV = Clamp;
};

#include "FakeCubeUtils.fxh"
 
cbuffer cbPerDraw : register( b0 )
{
	float4x4 tVP : VIEWPROJECTION;
	float4 cAmb <bool color=true;String uiname="Color";> = { 1.0f,1.0f,1.0f,1.0f };
	float4x4 tTex <string uiname="Texture Transform"; bool uvspace=true; >;
	float4x4 tColor <string uiname="Color Transform";>;
	float dispamount = 0;
};


cbuffer cbPerObj : register( b1 )
{
	float4x4 tW : WORLD;

};

struct VS_IN
{
	float4 PosO : POSITION;
	float4 TexCd : TEXCOORD0;

};

struct vs2ps
{
    float4 PosWVP: SV_POSITION;
    float3 TexCd: TEXCOORD0;
};

vs2ps VS(VS_IN input)
{
    vs2ps Out = (vs2ps)0;
	
	float disp = fakecube.SampleLevel(volumeSampler, FakeCubeCoord(input.PosO.xyz),0).x;
	
	float3 normp = input.PosO.xyz;
	normp += disp*normp*dispamount;
    Out.PosWVP  = mul(float4(normp,1),mul(tW,tVP));
    Out.TexCd = normalize(input.PosO);
    return Out;
}




float4 PS(vs2ps In): SV_Target
{
	float3 txcd = FakeCubeCoord(In.TexCd);
    //float4 col = txcd.z;
	float4 col = fakecube.Sample(volumeSampler,txcd);
    return col;
}





technique10 Constant
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, PS() ) );
	}
}




