float4x4 tW: WORLD;
float4x4 tV: VIEW;
float4x4 tWV: WORLDVIEW;
float4x4 tWVP: WORLDVIEWPROJECTION;
float4x4 tP: PROJECTION;

Texture2D WorldMap <string uiname="WorldMap";>;
Texture2D Borders <string uiname="Borders";>;
Texture2D Continents <string uiname="Continents";>;
Texture2D IndexedTex <string uiname="IndexedMap";>;

float alpha;

#include "PhongDirectional.fxh"

SamplerState g_samLinear
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
};

float4x4 tTex <bool uvspace=true; string uiname="Texture Transform";>;
float4 HighLight <bool color=true; String uiname="Highlight Color";>  = {0.0, 0.0, 0.0, 1.0};
float4 BorderColor <bool color=true; String uiname="Border Color";>  = {0.0, 0.0, 0.0, 1.0};
float GlobeAlpha <String uiname="Globe Alpha";>;

struct vs2ps
{
    float4 PosWVP: SV_POSITION;
    float4 TexCd : TEXCOORD0;
    float3 LightDirV: TEXCOORD1;
    float3 NormV: TEXCOORD2;
    float3 ViewDirV: TEXCOORD3;
};

vs2ps VS(
    float4 PosO: POSITION,
    float3 NormO: NORMAL,
    float4 TexCd : TEXCOORD0
)
{
    vs2ps Out = (vs2ps)0;
    Out.LightDirV = normalize(-mul(lDir, tV));
    Out.NormV = normalize(mul(NormO, tWV));
    Out.PosWVP  = mul(PosO, tWVP);
    Out.TexCd = mul(TexCd, tTex);
    Out.ViewDirV = -normalize(mul(PosO, tWV));
    return Out;
}

float4 PS(vs2ps In): SV_Target
{
    float4 col = float4 (1.0, 1.0, 1.0, 1.0);
	//col.rgb *= PhongDirectional(In.NormV, In.ViewDirV, In.LightDirV).rgb;
	
	float4 borders = Borders.Sample(g_samLinear, In.TexCd.xy)*BorderColor;
	float4 continents = Continents.Sample(g_samLinear, In.TexCd.xy)/5.0;
	float4 worldmap = WorldMap.Sample(g_samLinear, In.TexCd.xy)*2;
	float4 IndCol = IndexedTex.Sample(g_samLinear, In.TexCd.xy);

	return col*continents;
	//return float4(col.rgb*(worldmap.rgb)+borders.rgb+continents.rgb, alpha*(continents.a*5.0)+GlobeAlpha+borders.r);
}
technique10 GouraudDirectional
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, PS() ) );
	}
}