﻿#region usings
using System;
using System.ComponentModel.Composition;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;
using VVVV.SkeletonInterfaces;

#endregion usings

namespace VVVV.Nodes
{
    #region PluginInfo
    [PluginInfo(Name = "Gravity", Category = "Value", Help = "Follows the input value with given Gravity and Friction", Author = "dominikkoller", Tags = "Force")]
    #endregion PluginInfo
    public class Gravity : IPluginEvaluate
    {
        #region fields & pins
        [Input("Input", DefaultValue = 1.0)]
        public ISpread<double> FGoal;

        [Input("Force", DefaultValue = 0.01)]
        public ISpread<double> FAccParam;

        [Input("Friction", DefaultValue = 0.97)]
        public ISpread<double> FFrictionParam;

        private ISpread<double> FVelocity;

        [Output("Output")]
        public ISpread<double> FPosition;

        #endregion fields & pins

        Gravity()
        {
            FVelocity = new Spread<double>();
        }

        //called when data for any output pin is requested
        public void Evaluate(int SpreadMax)
        {
            FGoal.SliceCount = SpreadMax;
            FAccParam.SliceCount = SpreadMax;
            FVelocity.SliceCount = SpreadMax;
            FPosition.SliceCount = SpreadMax;

            for (int i = 0; i < SpreadMax; i++)
            {
                var force = (FGoal[i] - FPosition[i]) * FAccParam[i];
                FVelocity[i] += force;
                FVelocity[i] *= FFrictionParam[i];
                FPosition[i] += FVelocity[i];
            }

            //FLogger.Log(LogType.Debug, "hi tty!");
        }
    }
}