

float4x4 tW: WORLD;
float4x4 tWV: WORLDVIEW;
float4x4 tWVP: WORLDVIEWPROJECTION;
float4x4 tWVIT:WORLDVIEWINVERSETRANSPOSE;
float4x4 tV: VIEW;
float4x4 tVI: VIEWINVERSE;
float4x4 tP: PROJECTION;

int slice;

StructuredBuffer<float4x4> iPreTr;


bool useTrBuf = false;

float Kd <float uimin=0.0; float uimax=1;> = 0.9;

float Ks <float uimin=0.0; float uimax=1;> = 0.5;
float LampIntensity <float uimin=0.0; float uimax=1000.0;> = 1;
float SpecExpon <float uimin=1.0; float uimax=128;> = 1.0;
float GlossTopUI <float uimin=0.2; float uimax=1.0;> = 0.46;
float GlossBotUI  <float uimin=0.05; float uimax=1.0;> = 0.46;
float GlossDrop  <float uimin=0.0; float uimax=0.05;> = 0.25;



float4 AmbiColor  <bool color=true; String uiname="Ambient Color";>  = {0.07f,0.07f,0.07f,1.0};
float4 SurfaceColor  <bool color=true;String uiname="Diffuse Color";>  = {0.85, 0.85, 0.85, 1};
float4 SpecColor  <bool color=true;String uiname="Specular";>  = {0.7, 0.7, 1,1};
float3 LampPos <string uiname="Light Direction";> = {0, -5,1}; 
float Alpha <float uimin=0.0; float uimax=1;> = 1;	
float4x4 tTex <bool uvspace=true; string uiname="Texture Transform";>;

Texture2DArray tex <string uiname="TextureArray";>;

Texture2D texture2d <string uiname="Texture"; >; 

SamplerState g_samLinear
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
};

bool FLIP_TEXTURE_Y;
bool OBJECT_SPACE_LIGHTS;

struct vs2ps
{
    float4 HPosition	: SV_POSITION;
    float2 UV		: TEXCOORD0;
    float3 LightVec	: TEXCOORD1;
    float3 WorldNormal	: TEXCOORD2;
    float3 WorldView	: TEXCOORD5;
	uint iiid : BlendIndices;
};

struct VS_IN
{
    float3 Position	: POSITION;
    float4 UV		: TEXCOORD0;
    float4 Normal	: NORMAL;
    //float4 Tangent	: TANGENT0;
    //float4 Binormal	: BINORMAL0;
	//uint iid : SV_InstanceID;
	//uint ii : SV_InstanceID;
	uint iiid : BlendIndices;
};

vs2ps VS(VS_IN In)
{
    vs2ps Out = (vs2ps)0;

	Out.WorldNormal = mul(In.Normal,tW).xyz;

    float4 Po = float4(In.Position.xyz,1);
	float4 Lo = float4(LampPos.xyz,1.0); // homogeneous coordinates
	
	
	//Po = mul(float4(Po.xyz,1),iPreTr[In.iid]);

	//float4x4 wo = iPreTr[In.iid];
	//wo = mul (wo, tW);
	//float4x4 wv = mul(wo,tV);
	
    float4 Pw = mul(Po,tW);	// convert to "world" space
	float4 Lw=mul(Lo,tW);
	    if(OBJECT_SPACE_LIGHTS==false)
	{
	float4 Lw = mul(Lo,tW);	// convert to "world" space
    Out.LightVec = (Lw.xyz - Pw.xyz);
	} 
	else 
	{
    Out.LightVec = (LampPos - Pw.xyz);
    }
	
if(FLIP_TEXTURE_Y==true) 
	{ 
      Out.UV = mul(float2(In.UV.x,(1.0-In.UV.y)),tTex);
	}
else //* !FLIP_TEXTURE_Y */
	{
    Out.UV = mul(In.UV.xy,tTex);
	}

    Out.WorldView = normalize(tVI[3].xyz - Pw.xyz);
    Out.HPosition = mul(Po,tWVP);
	Out.iiid = In.iiid;


    
    return Out;
}

float glossy_drop(float v,
		    uniform float top,
		    uniform float bot,
		    uniform float drop)
{
    return (drop+smoothstep(bot,top,v)*(1.0-drop));
}

void gloss_shared(vs2ps In,
	    uniform float3 SurfaceColor,
	    uniform float Ks,
	    uniform float SpecExpon,
	    uniform float3 SpecColor,
	    uniform float GlossTopUI,
	    uniform float GlossBotUI,
	    uniform float GlossDrop,
	    uniform float3 AmbiColor,
	    out float3 DiffuseContrib,
	    out float3 SpecularContrib)
{
    float3 Ln = normalize(In.LightVec.xyz);
    float3 Nn = normalize(In.WorldNormal);
    float3 Vn = normalize(In.WorldView);
    float3 Hn = normalize(Vn + Ln);
    float4 litV = lit(dot(Ln,Nn),dot(Hn,Nn),SpecExpon);
    float spec = litV.y * litV.z;
    float GlossTop = max(GlossTopUI,GlossBotUI);
    float GlossBot = min(GlossTopUI,GlossBotUI);
    spec *= (Ks * glossy_drop(spec,GlossTop,GlossBot,GlossDrop));
    SpecularContrib = spec * SpecColor;
    DiffuseContrib = litV.y * SurfaceColor + AmbiColor;
}







float4 glossyWetHilight_PS(vs2ps In): SV_Target
{

	
	float3 diffContrib;
    float3 specContrib;
	gloss_shared(In,SurfaceColor,Ks,SpecExpon,SpecColor,
			GlossTopUI,GlossBotUI,GlossDrop,
			AmbiColor,diffContrib,specContrib);
    //float3 map = texture2d.Sample(g_samLinear,In.UV).xyz;
	float3 map = tex.Sample(g_samLinear, float3(In.UV, In.iiid)).rgb;
    float3 result = specContrib + (map * diffContrib);
	
	
    return float4(result,Alpha);
	
    
}

technique10 TglossyWetHilight
{
	pass P0
	{
		SetGeometryShader( 0 );
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, glossyWetHilight_PS() ) );
	}
}

