/**
 * @license Angular UI Tree v2.1.5
 * (c) 2010-2014. https://github.com/JimLiu/angular-ui-tree
 * License: MIT
 */
(function(){"use strict";angular.module("ui.tree",[]).constant("treeConfig",{treeClass:"angular-ui-tree",emptyTreeClass:"angular-ui-tree-empty",hiddenClass:"angular-ui-tree-hidden",nodesClass:"angular-ui-tree-nodes",nodeClass:"angular-ui-tree-node",handleClass:"angular-ui-tree-handle",placeHolderClass:"angular-ui-tree-placeholder",dragClass:"angular-ui-tree-drag",dragThreshold:3,levelThreshold:30})})();(function(){"use strict";angular.module("ui.tree").factory("$uiTreeHelper",["$document","$window",function(e,t){return{nodesData:{},setNodeAttribute:function(e,t,n){if(!e.$modelValue)return null;var r=this.nodesData[e.$modelValue.$$hashKey];if(!r){r={};this.nodesData[e.$modelValue.$$hashKey]=r}r[t]=n},getNodeAttribute:function(e,t){if(!e.$modelValue)return null;var n=this.nodesData[e.$modelValue.$$hashKey];if(n){return n[t]}return null},nodrag:function(e){return typeof e.attr("data-nodrag")!="undefined"},eventObj:function(e){var t=e;if(e.targetTouches!==undefined){t=e.targetTouches.item(0)}else if(e.originalEvent!==undefined&&e.originalEvent.targetTouches!==undefined){t=e.originalEvent.targetTouches.item(0)}return t},dragInfo:function(e){return{source:e,sourceInfo:{nodeScope:e,index:e.index(),nodesScope:e.$parentNodesScope},index:e.index(),siblings:e.siblings().slice(0),parent:e.$parentNodesScope,moveTo:function(e,t,n){this.parent=e;this.siblings=t.slice(0);var r=this.siblings.indexOf(this.source);if(r>-1){this.siblings.splice(r,1);if(this.source.index()<n){n--}}this.siblings.splice(n,0,this.source);this.index=n},parentNode:function(){return this.parent.$nodeScope},prev:function(){if(this.index>0){return this.siblings[this.index-1]}return null},next:function(){if(this.index<this.siblings.length-1){return this.siblings[this.index+1]}return null},isDirty:function(){return this.source.$parentNodesScope!=this.parent||this.source.index()!=this.index},eventArgs:function(e,t){return{source:this.sourceInfo,dest:{index:this.index,nodesScope:this.parent},elements:e,pos:t}},apply:function(){var e=this.source.$modelValue;this.source.remove();this.parent.insertNode(this.index,e)}}},height:function(e){return e.prop("scrollHeight")},width:function(e){return e.prop("scrollWidth")},offset:function(n){var r=n[0].getBoundingClientRect();return{width:n.prop("offsetWidth"),height:n.prop("offsetHeight"),top:r.top+(t.pageYOffset||e[0].body.scrollTop||e[0].documentElement.scrollTop),left:r.left+(t.pageXOffset||e[0].body.scrollLeft||e[0].documentElement.scrollLeft)}},positionStarted:function(e,t){var n={};n.offsetX=e.pageX-this.offset(t).left;n.offsetY=e.pageY-this.offset(t).top;n.startX=n.lastX=e.pageX;n.startY=n.lastY=e.pageY;n.nowX=n.nowY=n.distX=n.distY=n.dirAx=0;n.dirX=n.dirY=n.lastDirX=n.lastDirY=n.distAxX=n.distAxY=0;return n},positionMoved:function(e,t,n){t.lastX=t.nowX;t.lastY=t.nowY;t.nowX=e.pageX;t.nowY=e.pageY;t.distX=t.nowX-t.lastX;t.distY=t.nowY-t.lastY;t.lastDirX=t.dirX;t.lastDirY=t.dirY;t.dirX=t.distX===0?0:t.distX>0?1:-1;t.dirY=t.distY===0?0:t.distY>0?1:-1;var r=Math.abs(t.distX)>Math.abs(t.distY)?1:0;if(n){t.dirAx=r;t.moving=true;return}if(t.dirAx!==r){t.distAxX=0;t.distAxY=0}else{t.distAxX+=Math.abs(t.distX);if(t.dirX!==0&&t.dirX!==t.lastDirX){t.distAxX=0}t.distAxY+=Math.abs(t.distY);if(t.dirY!==0&&t.dirY!==t.lastDirY){t.distAxY=0}}t.dirAx=r}}}])})();(function(){"use strict";angular.module("ui.tree").controller("TreeController",["$scope","$element","$attrs","treeConfig",function(e,t,n,r){this.scope=e;e.$element=t;e.$nodesScope=null;e.$type="uiTree";e.$emptyElm=null;e.$callbacks=null;e.dragEnabled=true;e.emptyPlaceHolderEnabled=true;e.maxDepth=0;e.dragDelay=0;e.isEmpty=function(){return e.$nodesScope&&e.$nodesScope.$modelValue&&e.$nodesScope.$modelValue.length===0};e.place=function(t){e.$nodesScope.$element.append(t);e.$emptyElm.remove()};e.resetEmptyElement=function(){if(e.$nodesScope.$modelValue.length===0&&e.emptyPlaceHolderEnabled){t.append(e.$emptyElm)}else{e.$emptyElm.remove()}};var i=function(e,t){var n=e.childNodes();for(var r=0;r<n.length;r++){t?n[r].collapse():n[r].expand();var s=n[r].$childNodesScope;if(s){i(s,t)}}};e.collapseAll=function(){i(e.$nodesScope,true)};e.expandAll=function(){i(e.$nodesScope,false)}}])})();(function(){"use strict";angular.module("ui.tree").controller("TreeNodesController",["$scope","$element","treeConfig",function(e,t,n){this.scope=e;e.$element=t;e.$modelValue=null;e.$nodeScope=null;e.$treeScope=null;e.$type="uiTreeNodes";e.$nodesMap={};e.nodrop=false;e.maxDepth=0;e.initSubNode=function(t){if(!t.$modelValue)return null;e.$nodesMap[t.$modelValue.$$hashKey]=t};e.destroySubNode=function(t){if(!t.$modelValue)return null;e.$nodesMap[t.$modelValue.$$hashKey]=null};e.accept=function(t,n){return e.$treeScope.$callbacks.accept(t,e,n)};e.beforeDrag=function(t){return e.$treeScope.$callbacks.beforeDrag(t)};e.isParent=function(t){return t.$parentNodesScope==e};e.hasChild=function(){return e.$modelValue.length>0};e.safeApply=function(e){var t=this.$root.$$phase;if(t=="$apply"||t=="$digest"){if(e&&typeof e==="function"){e()}}else{this.$apply(e)}};e.removeNode=function(t){var n=e.$modelValue.indexOf(t.$modelValue);if(n>-1){e.safeApply(function(){e.$modelValue.splice(n,1)[0]});return t}return null};e.insertNode=function(t,n){e.safeApply(function(){e.$modelValue.splice(t,0,n)})};e.childNodes=function(){var t=[];if(e.$modelValue){for(var n=0;n<e.$modelValue.length;n++){t.push(e.$nodesMap[e.$modelValue[n].$$hashKey])}}return t};e.depth=function(){if(e.$nodeScope){return e.$nodeScope.depth()}return 0};e.outOfDepth=function(t){var n=e.maxDepth||e.$treeScope.maxDepth;if(n>0){return e.depth()+t.maxSubDepth()+1>n}return false}}])})();(function(){"use strict";angular.module("ui.tree").controller("TreeNodeController",["$scope","$element","$attrs","treeConfig",function(e,t,n,r){this.scope=e;e.$element=t;e.$modelValue=null;e.$parentNodeScope=null;e.$childNodesScope=null;e.$parentNodesScope=null;e.$treeScope=null;e.$handleScope=null;e.$type="uiTreeNode";e.$$apply=false;e.collapsed=false;e.init=function(n){var r=n[0];e.$treeScope=n[1]?n[1].scope:null;e.$parentNodeScope=r.scope.$nodeScope;e.$modelValue=r.scope.$modelValue[e.$index];e.$parentNodesScope=r.scope;r.scope.initSubNode(e);t.on("$destroy",function(){r.scope.destroySubNode(e)})};e.index=function(){return e.$parentNodesScope.$modelValue.indexOf(e.$modelValue)};e.dragEnabled=function(){return!(e.$treeScope&&!e.$treeScope.dragEnabled)};e.isSibling=function(t){return e.$parentNodesScope==t.$parentNodesScope};e.isChild=function(t){var n=e.childNodes();return n&&n.indexOf(t)>-1};e.prev=function(){var t=e.index();if(t>0){return e.siblings()[t-1]}return null};e.siblings=function(){return e.$parentNodesScope.childNodes()};e.childNodesCount=function(){return e.childNodes()?e.childNodes().length:0};e.hasChild=function(){return e.childNodesCount()>0};e.childNodes=function(){return e.$childNodesScope&&e.$childNodesScope.$modelValue?e.$childNodesScope.childNodes():null};e.accept=function(t,n){return e.$childNodesScope&&e.$childNodesScope.$modelValue&&e.$childNodesScope.accept(t,n)};e.removeNode=function(){var t=e.remove();e.$callbacks.removed(t);return t};e.remove=function(){return e.$parentNodesScope.removeNode(e)};e.toggle=function(){e.collapsed=!e.collapsed};e.collapse=function(){e.collapsed=true};e.expand=function(){e.collapsed=false};e.depth=function(){var t=e.$parentNodeScope;if(t){return t.depth()+1}return 1};var i=0;var s=function(e){var t=0;var n=e.childNodes();for(var r=0;r<n.length;r++){var o=n[r].$childNodesScope;if(o){t=1;s(o)}}i+=t};e.maxSubDepth=function(){i=0;if(e.$childNodesScope){s(e.$childNodesScope)}return i}}])})();(function(){"use strict";angular.module("ui.tree").controller("TreeHandleController",["$scope","$element","$attrs","treeConfig",function(e,t,n,r){this.scope=e;e.$element=t;e.$nodeScope=null;e.$type="uiTreeHandle"}])})();(function(){"use strict";angular.module("ui.tree").directive("uiTree",["treeConfig","$window",function(e,t){return{restrict:"A",scope:true,controller:"TreeController",link:function(n,r,i){var s={accept:null,beforeDrag:null};var o={};angular.extend(o,e);if(o.treeClass){r.addClass(o.treeClass)}n.$emptyElm=angular.element(t.document.createElement("div"));if(o.emptyTreeClass){n.$emptyElm.addClass(o.emptyTreeClass)}n.$watch("$nodesScope.$modelValue.length",function(){if(n.$nodesScope.$modelValue){n.resetEmptyElement()}},true);n.$watch(i.dragEnabled,function(e){if(typeof e=="boolean"){n.dragEnabled=e}});n.$watch(i.emptyPlaceHolderEnabled,function(e){if(typeof e=="boolean"){n.emptyPlaceHolderEnabled=e}});n.$watch(i.maxDepth,function(e){if(typeof e=="number"){n.maxDepth=e}});n.$watch(i.dragDelay,function(e){if(typeof e=="number"){n.dragDelay=e}});s.accept=function(e,t,n){if(t.nodrop||t.outOfDepth(e)){return false}return true};s.beforeDrag=function(e){return true};s.removed=function(e){};s.dropped=function(e){};s.dragStart=function(e){};s.dragMove=function(e){};s.dragStop=function(e){};s.beforeDrop=function(e){};n.$watch(i.uiTree,function(e,t){angular.forEach(e,function(e,t){if(s[t]){if(typeof e==="function"){s[t]=e}}});n.$callbacks=s},true)}}}])})();(function(){"use strict";angular.module("ui.tree").directive("uiTreeNodes",["treeConfig","$window",function(e){return{require:["ngModel","?^uiTreeNode","^uiTree"],restrict:"A",scope:true,controller:"TreeNodesController",link:function(t,n,r,i){var s={};angular.extend(s,e);if(s.nodesClass){n.addClass(s.nodesClass)}var o=i[0];var u=i[1];var a=i[2];if(u){u.scope.$childNodesScope=t;t.$nodeScope=u.scope}else{a.scope.$nodesScope=t}t.$treeScope=a.scope;if(o){o.$render=function(){if(!o.$modelValue||!angular.isArray(o.$modelValue)){t.$modelValue=[]}t.$modelValue=o.$modelValue}}t.$watch(r.maxDepth,function(e){if(typeof e=="number"){t.maxDepth=e}});r.$observe("nodrop",function(e){t.nodrop=typeof e!="undefined"});r.$observe("horizontal",function(e){t.horizontal=typeof e!="undefined"})}}}])})();(function(){"use strict";angular.module("ui.tree").directive("uiTreeNode",["treeConfig","$uiTreeHelper","$window","$document","$timeout",function(e,t,n,r,i){return{require:["^uiTreeNodes","^uiTree"],restrict:"A",controller:"TreeNodeController",link:function(s,o,u,a){var f={};angular.extend(f,e);if(f.nodeClass){o.addClass(f.nodeClass)}s.init(a);s.collapsed=!!t.getNodeAttribute(s,"collapsed");s.$watch(u.collapsed,function(e){if(typeof e=="boolean"){s.collapsed=e}});s.$watch("collapsed",function(e){t.setNodeAttribute(s,"collapsed",e);u.$set("collapsed",e)});var l="ontouchstart"in window;var c,h,p,d;var v,m,g;var y=null;var b;var w=true;var E=false;var S=null;var x=document.body,T=document.documentElement,N,C;var k=function(e){if(!l&&(e.button==2||e.which==3)){return}if(e.uiTreeDragging||e.originalEvent&&e.originalEvent.uiTreeDragging){return}var i=angular.element(e.target);var u=i.scope();if(!u||!u.$type){return}if(u.$type!="uiTreeNode"&&u.$type!="uiTreeHandle"){return}if(u.$type=="uiTreeNode"&&u.$handleScope){return}var a=i.prop("tagName").toLowerCase();if(a=="input"||a=="textarea"||a=="button"||a=="select"){return}while(i&&i[0]&&i[0]!=o){if(t.nodrag(i)){return}i=i.parent()}if(!s.beforeDrag(s)){return}e.uiTreeDragging=true;if(e.originalEvent){e.originalEvent.uiTreeDragging=true}e.preventDefault();var c=t.eventObj(e);h=true;p=t.dragInfo(s);var y=s.$element.prop("tagName");if(y.toLowerCase()==="tr"){v=angular.element(n.document.createElement(y));var w=angular.element(n.document.createElement("td")).addClass(f.placeHolderClass);v.append(w)}else{v=angular.element(n.document.createElement(y)).addClass(f.placeHolderClass)}m=angular.element(n.document.createElement(y));if(f.hiddenClass){m.addClass(f.hiddenClass)}d=t.positionStarted(c,s.$element);v.css("height",t.height(s.$element)+"px");v.css("width",t.width(s.$element)+"px");g=angular.element(n.document.createElement(s.$parentNodesScope.$element.prop("tagName"))).addClass(s.$parentNodesScope.$element.attr("class")).addClass(f.dragClass);g.css("width",t.width(s.$element)+"px");g.css("z-index",9999);var E=(s.$element[0].querySelector(".angular-ui-tree-handle")||s.$element[0]).currentStyle;if(E){document.body.setAttribute("ui-tree-cursor",r.find("body").css("cursor")||"");r.find("body").css({cursor:E.cursor+"!important"})}s.$element.after(v);s.$element.after(m);g.append(s.$element);r.find("body").append(g);g.css({left:c.pageX-d.offsetX+"px",top:c.pageY-d.offsetY+"px"});b={placeholder:v,dragging:g};angular.element(r).bind("touchend",_);angular.element(r).bind("touchcancel",_);angular.element(r).bind("touchmove",M);angular.element(r).bind("mouseup",_);angular.element(r).bind("mousemove",M);angular.element(r).bind("mouseleave",D);N=Math.max(x.scrollHeight,x.offsetHeight,T.clientHeight,T.scrollHeight,T.offsetHeight);C=Math.max(x.scrollWidth,x.offsetWidth,T.clientWidth,T.scrollWidth,T.offsetWidth)};var L=function(e){if(!E){if(!w){E=true;s.$apply(function(){s.$callbacks.dragStart(p.eventArgs(b,d))})}return}var r=t.eventObj(e);var i,o,u;if(g){e.preventDefault();if(n.getSelection){n.getSelection().removeAllRanges()}else if(n.document.selection){n.document.selection.empty()}o=r.pageX-d.offsetX;u=r.pageY-d.offsetY;if(o<0){o=0}if(u<0){u=0}if(u+10>N){u=N-10}if(o+10>C){o=C-10}g.css({left:o+"px",top:u+"px"});var a=window.pageYOffset||n.document.documentElement.scrollTop;var l=a+(window.innerHeight||n.document.clientHeight||n.document.clientHeight);if(l<r.pageY&&l<=N){window.scrollBy(0,10)}if(a>r.pageY){window.scrollBy(0,-10)}t.positionMoved(e,d,h);if(h){h=false;return}if(d.dirAx&&d.distAxX>=f.levelThreshold){d.distAxX=0;if(d.distX>0){i=p.prev();if(i&&!i.collapsed&&i.accept(s,i.childNodesCount())){i.$childNodesScope.$element.append(v);p.moveTo(i.$childNodesScope,i.childNodes(),i.childNodesCount())}}if(d.distX<0){var c=p.next();if(!c){var m=p.parentNode();if(m&&m.$parentNodesScope.accept(s,m.index()+1)){m.$element.after(v);p.moveTo(m.$parentNodesScope,m.siblings(),m.index()+1)}}}}var S=t.offset(g).left-t.offset(v).left>=f.threshold;var x=r.pageX-n.document.body.scrollLeft;var T=r.pageY-(window.pageYOffset||n.document.documentElement.scrollTop);var k;if(angular.isFunction(g.hide)){g.hide()}else{k=g[0].style.display;g[0].style.display="none"}n.document.elementFromPoint(x,T);var L=angular.element(n.document.elementFromPoint(x,T));if(angular.isFunction(g.show)){g.show()}else{g[0].style.display=k}if(!d.dirAx){var A,O;O=L.scope();var M=false;if(!O){return}if(O.$type=="uiTree"&&O.dragEnabled){M=O.isEmpty()}if(O.$type=="uiTreeHandle"){O=O.$nodeScope}if(O.$type!="uiTreeNode"&&!M){return}if(y&&v.parent()[0]!=y.$element[0]){y.resetEmptyElement();y=null}if(M){y=O;if(O.$nodesScope.accept(s,0)){O.place(v);p.moveTo(O.$nodesScope,O.$nodesScope.childNodes(),0)}}else if(O.dragEnabled()){L=O.$element;var _=t.offset(L);A=O.horizontal?r.pageX<_.left+t.width(L)/2:r.pageY<_.top+t.height(L)/2;if(O.$parentNodesScope.accept(s,O.index())){if(A){L[0].parentNode.insertBefore(v[0],L[0]);p.moveTo(O.$parentNodesScope,O.siblings(),O.index())}else{L.after(v);p.moveTo(O.$parentNodesScope,O.siblings(),O.index()+1)}}else if(!A&&O.accept(s,O.childNodesCount())){O.$childNodesScope.$element.append(v);p.moveTo(O.$childNodesScope,O.childNodes(),O.childNodesCount())}}}s.$apply(function(){s.$callbacks.dragMove(p.eventArgs(b,d))})}};var A=function(e){e.preventDefault();if(g){s.$treeScope.$apply(function(){s.$callbacks.beforeDrop(p.eventArgs(b,d))});m.replaceWith(s.$element);v.remove();g.remove();g=null;if(s.$$apply){p.apply();s.$treeScope.$apply(function(){s.$callbacks.dropped(p.eventArgs(b,d))})}else{P()}s.$treeScope.$apply(function(){s.$callbacks.dragStop(p.eventArgs(b,d))});s.$$apply=false;p=null}var t=document.body.getAttribute("ui-tree-cursor");if(t!==null){r.find("body").css({cursor:t});document.body.removeAttribute("ui-tree-cursor")}angular.element(r).unbind("touchend",_);angular.element(r).unbind("touchcancel",_);angular.element(r).unbind("touchmove",M);angular.element(r).unbind("mouseup",_);angular.element(r).unbind("mousemove",M);angular.element(n.document.body).unbind("mouseleave",D)};var O=function(e){if(s.dragEnabled()){k(e)}};var M=function(e){L(e)};var _=function(e){s.$$apply=true;A(e)};var D=function(e){A(e)};var P=function(){o.bind("touchstart mousedown",function(e){w=true;E=false;O(e);S=i(function(){w=false},s.dragDelay)});o.bind("touchend touchcancel mouseup",function(){i.cancel(S)})};P();angular.element(n.document.body).bind("keydown",function(e){if(e.keyCode==27){s.$$apply=false;A(e)}})}}}])})();(function(){"use strict";angular.module("ui.tree").directive("uiTreeHandle",["treeConfig","$window",function(e){return{require:"^uiTreeNode",restrict:"A",scope:true,controller:"TreeHandleController",link:function(t,n,r,i){var s={};angular.extend(s,e);if(s.handleClass){n.addClass(s.handleClass)}if(t!=i.scope){t.$nodeScope=i.scope;i.scope.$handleScope=t}}}}])})()