cbuffer cbControls:register(b0){
#include "../../../nodes/dx11/globalVariables.fxh"
};
#include "../../../nodes/dx11/usefulFunctions.fxh"
float shape(float3 pos){
	float res= opU(sdCylinder(pos,float2(0.25,1.5)),sdBox(pos-float3(0,1,0),float3(0.5,0.2,0.5)));
	res = opU(res,sdCylinder(pos+float3(0,-1,0),float2(0.9,0.07)));
	return res;
}
float shapeSmoothUnion(float3 pos){
	//USE "opUsmin" instead of opU for smooth blending, 
	//you must add one more parameter: smooth radius, like this:
	//opUsmin(sdSphere(pos,0.7),sdBox(pos.0.5),radius);
	//which here is 0.05 and then 0.25:
	float res= opUsmin(sdCylinder(pos,float2(0.25,1.5)),sdBox(pos-float3(0,1,0),float3(0.5,0.2,0.5)),0.05);
	res = opUsmin(res,sdCylinder(pos+float3(0,-1,0),float2(0.9,0.07)),0.25);
	return res;
}

float shapeStairsUnion(float3 pos){
	//USE "opUsminStairs" instead of opU for super cool Mercury stair blending, 
	//you must add TWO more parameters: radius and amount of stairs, like this:
	//opUsminStairs(sdSphere(pos,0.7),sdBox(pos.0.5),radius,amountOfStairs)	
	float res= opUstairs(sdCylinder(pos,float2(0.25,1.5)),sdBox(pos-float3(0,1,0),float3(0.5,0.2,0.5)),0.3,4);
	res = opUstairs(res,sdCylinder(pos+float3(0,-1,0),float2(0.9,0.07)),0.3,4);
	return res;
}
float shapeSubstract(float3 pos){
	//USE "opSsmin" instead of opS for smooth blending, 
	//you must add ONE more parameters: radius, like this:
	//opSsmin(sdSphere(pos,0.7),sdBox(pos.0.5),radius)	
	float res= opU(sdCylinder(pos+float3(0,-1,0),float2(0.9,0.07)),sdBox(pos-float3(0,1,0),float3(0.5,0.2,0.5)));
	res = opS(sdCylinder(pos,float2(0.25,1.5)),res);
	return res;
}
float shapeStairsSubstract(float3 pos){
	//USE "opSstairs" instead of opS for super cool Mercury stair blending, 
	//you must add TWO more parameters: radius and amount of stairs, like this:
	//opSstairs(sdSphere(pos,0.7),sdBox(pos.0.5),radius,amountOfStairs)	
	float res= opUstairs(sdCylinder(pos+float3(0,-1,0),float2(0.9,0.07)),sdBox(pos-float3(0,1,0),float3(0.5,0.2,0.5)),0.3,4);
	res = opSstairs(res,sdCylinder(pos,float2(0.25,1.5)),0.3,4);
	return res;
}
float shapeSmoothSubstract(float3 pos){
	//USE "opSsmin" instead of opS for smooth blending, 
	//you must add ONE more parameters: radius, like this:
	//opSsmin(sdSphere(pos,0.7),sdBox(pos.0.5),radius)	
	float res= opUsmin(sdCylinder(pos+float3(0,-1,0),float2(0.9,0.07)),sdBox(pos-float3(0,1,0),float3(0.5,0.2,0.5)),0.3);
	res = opSsmin(res,sdCylinder(pos,float2(0.25,1.5)),0.3);
	return res;
}
float2 drawYourShit( float3 pos )
{	
	float3 offset = float3(0.7,0,0.7);	
	float2 d = opU(float2(sdPlane(pos),1.0),
				   float2(shapeSmoothUnion(pos+offset),40.));	
	d = opU(d,float2(shape(pos-offset),40.));
	d = opU(d,float2(shapeStairsUnion(pos-offset*3),40.));
	d = opU(d,float2(shapeSubstract(pos-float3(-1.22,0,2.07)),40.));
	d = opU(d,float2(shapeStairsSubstract(pos-float3(0.5,0,3.6)),40.));
	d = opU(d,float2(shapeSmoothSubstract(pos-float3(-2.56,0,0.34)),40.));
	//ADD THIS LINE TO GO THROUGH GEOMETRY LIKE BUTTER WITH YOUR CAMERA
	//d.x=max(-sdSphere(pos-ro,2.5),d.x);
	return d;	
}
#include "../../../nodes/dx11/marchingFunctions.fxh"

void colourYourShit(float m){
	if(m<1.5){ 
		col = 0.3 + 0.1*abs(fmod( floor(5.0*pos.z) + floor(5.0*pos.x), 2.0));
    }
};
void finalPassShit(){};  

#include "../../../nodes/dx11/render.fxh"
technique10 raymarch_depth{
	pass P0{
		SetVertexShader(CompileShader(vs_5_0,VS()));
		SetPixelShader(CompileShader(ps_5_0,PS()));
	}
}