//@author: vux
//@help: standard constant shader
//@tags: color
//@credits: 

struct vsInput
{
    float4 posObject : POSITION;
};

struct psInput
{
    float4 posScreen : SV_Position;
	 float4 posWorld : POSWORLD;
};

struct vsInputTextured
{
    float4 posObject : POSITION;
	float4 uv: TEXCOORD0;
};

struct psInputTextured
{
    float4 posScreen : SV_Position;
    float4 uv: TEXCOORD0;
};

Texture2D inputTexture <string uiname="Texture";>;

SamplerState linearSampler <string uiname="Sampler State";>
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Clamp;
    AddressV = Clamp;
};

cbuffer cbPerDraw : register(b0)
{
	float4x4 tV: LAYERVIEW;
	float4x4 tVP : LAYERVIEWPROJECTION;
};

cbuffer cbPerObj : register( b1 )
{
	float4x4 tW : WORLD;
	float4x4 tWP : WORLDPROJECTION;
	float4x4 tVI:VIEWINVERSE;
	float Alpha <float uimin=0.0; float uimax=1.0;> = 1; 
	float4 cAmb <bool color=true;String uiname="Color";> = { 1.0f,1.0f,1.0f,1.0f };
	float4x4 tColor <string uiname="Color Transform";>;
	float fogIntensity <string uinazme="Fog Intensity";> = 0.2;
	float4 fogColour <bool color=true;string uiname="Fog colour";> = { 0.6,0.71,0.75,1.0 };
	float4 skyColour <bool color=true;string uiname="sky colour";> = { 0.6,0.71,0.75,1.0 };
	float sunIntensity <string uinazme="Sun Intensity";> = 0.2;
		float3 lig <string uiname="Sunlight Direction";>;
};

cbuffer cbTextureData : register(b2)
{
	float4x4 tTex <string uiname="Texture Transform"; bool uvspace=true; >;
};

psInput VS(vsInput input)
{
	psInput output;
	output.posScreen = mul(input.posObject,mul(tW,tVP));
	output.posWorld=mul(input.posObject,tW);
	return output;
}

psInputTextured VS_Textured(vsInputTextured input)
{
	psInputTextured output;
	output.posScreen = mul(input.posObject,mul(tW,tVP));
	output.uv = mul(input.uv, tTex);
	return output;
}


float4 PS(psInput input): SV_Target
{
    float4 col = cAmb;
	col = mul(col, tColor);
	col.a *= Alpha;
	float3 camPos= float3(tVI._41,tVI._42,tVI._43);	
	float t = distance(input.posWorld.xyz,camPos);
	float3 camDir= float3(tV._31,tV._32,tV._33);
	float yInv =1-camDir.y;
	camDir.y=-camDir.y;
		camDir.x=-camDir.x;

	float3 skyCol = skyColour.xyz - yInv*0.2*float3(1.0,0.5,1.0) + 0.15*0.5;		
			float sun = clamp(dot(lig,camDir), 0.0, 1.0 );
			float3 fogCol = skyCol+sunIntensity*float3(1.0,.6,0.1)*pow(sun, 8.0 );	
			col.xyz = lerp( col.xyz, fogCol.xyz, 1.0-exp( -0.0001*fogIntensity*t*t*t ) );
	
	
	
	col.xyz += 0.2*float3(1.0,0.4,0.2)*pow( sun, 3.0 );
	
    return col;
}


float4 PS_Textured(psInputTextured input): SV_Target
{
    float4 col = inputTexture.Sample(linearSampler,input.uv.xy) * cAmb;
	col = mul(col, tColor);
	col.a *= Alpha;
    return col;
}

technique11 Constant <string noTexCdFallback="ConstantNoTexture"; >
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS_Textured() ) );
		SetPixelShader( CompileShader( ps_4_0, PS_Textured() ) );
	}
}

technique11 ConstantNoTexture
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, PS() ) );
	}
}





