float2 castRay( float3 ro, float3 rd )
{
	//float t = near;
	float t = near;
	//don't forget to replace line above as well
    float m = -1.0;
    for( int i=0; i<STEPAMOUNT; i++ )
    {
	    float precis = STEPPRECISION*t;
	   	float2 res = drawYourShit( ro+rd*t );
        if( res.x<precis || t>far ) break;
        t += res.x;
	    m = res.y;
    }
    if( t>far ) m=1.;
    return float2( t, m );
}
#ifndef SHADOWMIN
	#define SHADOWMIN 0.05
#endif
#ifndef SHADOWMAX
	#define SHADOWMAX 2.5
#endif
float softshadow( float3 ro, float3 rd )
{
	float res = 1.0;
    float t = SHADOWMIN;
    for( int i=0; i<16; i++ )
    {
		float h = drawYourShit( ro + rd*t ).x;
        res = min( res, 8.0*h/t );
        t += clamp( h, 0.02, 0.10 );
        if( h<0.001 || t>SHADOWMAX) break;
    }
    return clamp( res, 0.0, 1.0 );
}
float3 calcNormal( float3 pos )
{
   float2 e = float2(1.0,-1.0)*0.5773*0.0005;
    return normalize( e.xyy*drawYourShit( pos + e.xyy ).x + 
					  e.yyx*drawYourShit( pos + e.yyx ).x + 
					  e.yxy*drawYourShit( pos + e.yxy ).x + 
					  e.xxx*drawYourShit( pos + e.xxx ).x );
}
float calcAO( float3 pos, float3 nor )
{
	float occ = 0.0;
    float sca = 1.0;
    for( int i=0; i<5; i++ )
    {
        float hr = 0.01 + 0.12*float(i)/4.0;
        float3 aopos =  nor * hr + pos;
        float dd = drawYourShit( aopos ).x;
        occ += -(dd-hr)*sca;
        sca *= 0.95;
    }
    return clamp( 1.0 - 3.0*occ, 0.0, 1.0 );    
}

//////---------------------!!
////// PBR shit           //	
//////--------------------!!

#ifndef NBLIGHTS
	#define NBLIGHTS 1
#endif
#define GOLD float3(1.0, 0.71, 0.29)
#define COPPER float3(0.95, 0.64, 0.54)
#define IRON float3(0.56, 0.57, 0.58)
#define ALUMINIUM float3(0.91, 0.92, 0.92)
#define SILVER float3(0.95, 0.93, 0.88)
//#define NB_MATERIALS 1
#define MATERIAL_STRIDE 24
#define MATERIAL_STRIDEBY2 12

struct Light {
    float3 pos: MYASS;
    float3 color: MYBALLS;
};

static Light lights[NBLIGHTS];

Light newLight(float3 pos, float3 color){
    Light light;
    light.pos=pos;
    light.color=color;
    return light;
}

float3 half_vector(float3 v1, float3 v2) {
    return normalize(v1 + v2);
}

// https://en.wikipedia.org/wiki/Specular_highlight#Cook.E2.80.93Torrance_model
float geometric_attenuation(float3 n, float3 v, float3 l) {
    float3 h = half_vector(v, l);

    float c = 2.0 * dot(h, n) / dot(v, h);
    float g1 = c * dot(v, n);
    float g2 = c * dot(l, n);

    return min(1.0, min(g1, g2));
}


// https://en.wikipedia.org/wiki/Specular_highlight#Beckmann_distribution
float beckmann_distribution(float3 n, float3 v, float3 l, float roughness) {
    float3 h = half_vector(v, l);
    float m = roughness;

    float n_dot_h = dot(n, h);
    float n_dot_h_sq = n_dot_h * n_dot_h;
    float n_dot_h_qu = n_dot_h_sq * n_dot_h_sq;
    float m_sq = m * m;

    float expr1 = (n_dot_h_sq - 1.0) / (n_dot_h_sq * m_sq);
    float expr2 = PI * m_sq * n_dot_h_qu;

    return exp(expr1) / expr2;
}

// with a separate reflection coefficient for each color channel
float3 shlick_fresnel(float3 n, float3 v, float3 l, float3 reflection_coefficients) {
    float3 h = half_vector(v, l);
    float3 c = reflection_coefficients;

    float hv = dot(h, v);
    return c + (1.0 - c) * pow(1.0 - hv, 5.0);
}

float3 computePBRLighting ( Light light, float3 position, float3 N, float3 V, float3 albedo, float roughness, float3 F0 ) {
    float3 n = N;
    float3 v = V;
    float3 l = normalize(light.pos.xyz - position);
    
    float d = beckmann_distribution(n, v, l, roughness);
    float g = geometric_attenuation(n, v, l);
    float dotnl = dot (n,l);
    float3 specular;
    #ifdef REFLECTION
    // https://en.wikipedia.org/wiki/Schlick%27s_approximation but for each channel
    float3 reflection_coefficients = F0;
	#else
	float3 reflection_coefficients = 0;	
	#endif
    float3 f = shlick_fresnel(n, v, l, reflection_coefficients);
    float3 k = d * f * g / (4.0 * dot(v, n) * dot(n, l));
    specular = k;    
	
    
    float3 ambient = 0.01;
    float3 diffuse = albedo / PI;
#ifdef BACKLIGHT
        	float bac = 0.125*clamp( dot( nor, normalize(float3(-l.x,0.0,-l.z))), 0.0, 1.0 )*clamp( 1.0-pos.y,0.0,1.0);
	#else
	float bac=0;
    	#endif
    return ambient + (diffuse + specular) * light.color.xyz * dotnl+bac;
}

float3 addPBR( float3 position, float3 N, float3 V, float3 baseColor, float metalMask, float smoothness, float reflectance) {
        float3 color =0.0;

        float roughness = 1.0 - smoothness*smoothness;
        float3 F0 = 0.16*reflectance*reflectance * (1.0-metalMask) +baseColor*metalMask;
        float3 albedo = baseColor;

        float s = 0.0;
		#ifdef FRESNEL
        	float fre = pow( clamp(1.0+dot(nor,rd),0.0,1.0), 2.0 );
    	#endif
		#ifdef AMBIENTOCCLUSION
        	float occ = calcAO( pos, nor );
    	#else
    		float occ=1;
    	#endif	
        for ( int i = 0; i < NBLIGHTS; ++i ) {
            float3 col = computePBRLighting ( lights[i], position, N, V, albedo, roughness, F0);
        	
            color += col; 
        	
        	#ifdef SHADOWS
            s += softshadow( position, normalize(lights[i].pos.xyz - position) );
        	#else
        	s+=1;
        	#endif
        }
	#ifdef FRESNEL
        	color += 0.25*fre*occ;
    	#endif

        return color*s*occ;
    }