//@author: vux
//@help: basic pixel based lightning with directional light
//@tags: shading, blinn
//@credits: vvvv group

struct vsInput
{
    float4 posObject : POSITION;
	float4 normalObject : NORMAL;
};

struct psInput
{
    float4 posScreen : SV_Position;
	float4 posWorld : POSWORLD;
    float3 LightDirV: TEXCOORD0;
    float3 NormV: TEXCOORD1;
    float3 ViewDirV: TEXCOORD2;
};

struct vsInputTextured
{
    float4 posObject : POSITION;
	float4 normalObject : NORMAL;
	float4 uv: TEXCOORD0;
};

struct psInputTextured
{
    float4 posScreen : SV_Position;
	float4 posWorld : POSWORLD;
    float4 uv: TEXCOORD0;
    float3 LightDirV: TEXCOORD1;
    float3 NormV: TEXCOORD2;
    float3 ViewDirV: TEXCOORD3;
};

Texture2D inputTexture <string uiname="Texture";>;

SamplerState linearSampler <string uiname="Sampler State";>
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Clamp;
    AddressV = Clamp;
}; 

cbuffer cbPerDraw : register(b0)
{
	float4x4 tV: LAYERVIEW;
	float4x4 tP: PROJECTION;
	float4x4 tLVP: LAYERVIEWPROJECTION;
};

cbuffer cbPerObj : register( b1 )
{
	float4x4 tW : WORLD;
	float4x4 tWV: WORLDVIEW;
	float4x4 tWIT: WORLDLAYERINVERSETRANSPOSE;
	float4x4 tVI:VIEWINVERSE;
	float4x4 tVPI:VIEWPROJECTIONINVERSE;
	float4x4 tVP:VIEWPROJECTION;
	float Alpha <float uimin=0.0; float uimax=1.0;> = 1; 
	float4 cAmb <bool color=true;String uiname="Color";> = { 1.0f,1.0f,1.0f,1.0f };
	float4x4 tColor <string uiname="Color Transform";>;
};

cbuffer cbTextureData : register(b2)
{
	float4x4 tTex <string uiname="Texture Transform"; bool uvspace=true; >;
};


cbuffer cbLightData : register(b3)
{
	//light properties
	float3 lDir <string uiname="Light Direction";> = {0, -5, 2};        //light direction in world space
	float4 lAmb  <bool color=true; String uiname="Ambient Color";>  = {0.15, 0.15, 0.15, 1};
	float4 lDiff <bool color=true; String uiname="Diffuse Color";>  = {0.85, 0.85, 0.85, 1};
	float4 lSpec <bool color=true; String uiname="Specular Color";> = {0.35, 0.35, 0.35, 1};
	float lPower <String uiname="Power"; float uimin=0.0;> = 25.0;     //shininess of specular highlight	
	float fogIntensity <string uinazme="Fog Intensity";> = 0.2;
	float4 fogColour <bool color=true;string uiname="Fog colour";> = { 0.6,0.71,0.75,1.0 };
	float4 skyColour <bool color=true;string uiname="sky colour";> = { 0.6,0.71,0.75,1.0 };
	float sunIntensity <string uinazme="Sun Intensity";> = 0.2;
		float3 lig <string uiname="Sunlight Direction";>;
}

//phong directional function
float4 PhongDirectional(float3 NormV, float3 ViewDirV, float3 LightDirV)
{
	float4 amb = float4(lAmb.rgb, 1);
    //halfvector
    float3 H = normalize(ViewDirV + LightDirV);

    //compute blinn lighting
    float3 shades = lit(dot(NormV, LightDirV), dot(NormV, H), lPower).rgb;

    float4 diff = lDiff * shades.y;
    diff.a = 1;

    //reflection vector (view space)
    float3 R = normalize(2 * dot(NormV, LightDirV) * NormV - LightDirV);

    //normalized view direction (view space)
    float3 V = normalize(ViewDirV);

    //calculate specular light
    float4 spec = pow(max(dot(R, V),0), lPower*.2) * lSpec;

    return (amb + diff) + spec;
}

psInputTextured VS_Textured(float4 PosO: POSITION,float3 NormO: NORMAL, float4 TexCd : TEXCOORD0)
{
    psInputTextured output;
  
    //inverse light direction in view space
    output.LightDirV = normalize(-mul(float4(lDir,0.0f), mul(tW,tV)).xyz);
    
    //normal in view space
    output.NormV = normalize(mul(mul(NormO, (float3x3)tWIT),(float3x3)tV).xyz);

    //position (projected)
	output.posWorld  = mul(PosO, tW);
    output.posScreen  = mul(PosO, mul(tW, tLVP));
    output.uv = mul(TexCd, tTex);
    output.ViewDirV = -normalize(mul(PosO, tWV).xyz);
    return output;
}

psInput VS(float4 PosO: POSITION,float3 NormO: NORMAL)
{
    psInput output;

    //inverse light direction in view space
    output.LightDirV = normalize(-mul(float4(lDir,0.0f), mul(tW,tV)).xyz);
     
    //normal in view space
    output.NormV = normalize(mul(mul(NormO, (float3x3)tWIT),(float3x3)tV).xyz);

    //position (projected)
	output.posWorld  = mul(PosO, tW);
    output.posScreen  = mul(PosO, mul(tW, tLVP));
    output.ViewDirV = -normalize(mul(PosO, tWV).xyz);
    return output;
}

float4 PS_Textured(psInputTextured input): SV_Target
{
    float4 col = inputTexture.Sample(linearSampler, input.uv.xy);
    col.rgb *= PhongDirectional(input.NormV, input.ViewDirV, input.LightDirV).xyz;
    col.a *= Alpha;
	float3 camPos= float3(tVI._41,tVI._42,tVI._43);	
	float t = distance(input.posWorld.xyz,camPos);
	col=mul(col, tColor);
	float3 camDir= float3(tVI._31,tVI._32,tVI._33);
	float yInv =1-camDir.y;
	//camDir.y=camDir.y;
	//	camDir.x=-camDir.x;

	float3 skyCol = skyColour.xyz - yInv*0.2*float3(1.0,0.5,1.0) + 0.15*0.5;		
			float sun = clamp(dot(lig,camDir), 0.0, 1.0 );
			float3 fogCol = skyCol+sunIntensity*float3(1.0,.6,0.1)*pow(sun, 8.0 );	
			col.xyz = lerp( col.xyz, fogCol.xyz, 1.0-exp( -0.0001*fogIntensity*t*t*t*t ) );
	
	
	
	col.xyz += 0.2*float3(1.0,0.4,0.2)*pow( sun, 3.0 );
	
	
	//col.xyz = lerp( col.xyz, fogColour.xyz, clamp(dist*fogIntensity,0,1) );
    return col;
}

float4 PS(psInput input): SV_Target
{
    float4 col = 1;
    col.rgb *= PhongDirectional(input.NormV, input.ViewDirV, input.LightDirV).xyz;
    col.a *= Alpha;
	float3 camPos= float3(tVI._41,tVI._42,tVI._43);	
	float t = distance(input.posWorld.xyz,camPos);
	col=mul(col, tColor);
	float3 camDir= float3(tVI._31,tVI._32,tVI._33);
	float yInv =1-camDir.y;
	//camDir.y=camDir.y;
	//	camDir.x=-camDir.x;

	float3 skyCol = skyColour.xyz - yInv*0.2*float3(1.0,0.5,1.0) + 0.15*0.5;		
			float sun = clamp(dot(lig,camDir), 0.0, 1.0 );
			float3 fogCol = skyCol+sunIntensity*float3(1.0,.6,0.1)*pow(sun, 8.0 );	
			col.xyz = lerp( col.xyz, fogCol.xyz, 1.0-exp( -0.0001*fogIntensity*t*t*t*t ) );
	
	
	
	col.xyz += 0.2*float3(1.0,0.4,0.2)*pow( sun, 3.0 );
	
	
	//col.xyz = lerp( col.xyz, fogColour.xyz, clamp(dist*fogIntensity,0,1) );
    return col;
}



technique10 GouraudDirectional <string noTexCdFallback="GouraudDirectionalNotexture"; >
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS_Textured() ) );
		SetPixelShader( CompileShader( ps_4_0, PS_Textured() ) );
	}
}

technique11 GouraudDirectionalNotexture
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, PS() ) );
	}
}

