/*
* PLEASE LOOK IN "marching_functions.fxh" for more PBR functions and references...
* 
* References :
*
* http://renderwonk.com/publications/s2010-shading-course/hoffman/s2010_physically_based_shading_hoffman_b_notes.pdf
* 
* http://www.frostbite.com/wp-content/uploads/2014/11/course_notes_moving_frostbite_to_pbr.pdf
*
* http://graphicrants.blogspot.fr/2013/08/specular-brdf-reference.html
*
* http://www.filmicworlds.com/2014/04/21/optimizing-ggx-shaders-with-dotlh/
*
* http://blog.selfshadow.com/publications/s2013-shading-course/#course_content
*
*	Ray marching code from iq
*/

//PBR implementation by: 2v_S - https://www.shadertoy.com/view/MlB3DV

void render()
{ 
    float yInv = 1-rd.y;
    col = 1.0;
    #ifndef FOG
        col = skyColour.xyz - yInv*0.2*fogMult + 0.15*0.5;
        #ifdef SUN
            float sun = clamp(dot(lig,rd), 0.0, 1.0 );
            col += sunIntensity*float3(1.0,.6,0.1)*pow(sun, 8.0 );
        #endif
    #else
        
    #endif
    float2 res = castRay(ro,rd);
    float t = res.x;
    float m = res.y;
    
   		for ( int i = 0; i < NBLIGHTS; i++ ) {
           lights[i] = newLight(lightsPositions[i], lightsColors[i]);
        }
		//HOW TO MANUALY CREATES A LIGHT IN SHADER RATHER THAN FROM BUFFER
        //lights[0] = newLight(float3(-12.0*cos(-time), 8.0, 12.0*sin(-time)),.5);
        
        if(m>0) {           
            pos = ro + t*rd;
            nor= 0;
            nor = calcNormal(pos);
        	col = 0.45 + 0.35*sin(float3(0.05,0.08,0.10)*(m-1.0));
        	colourYourShit(m);        	           
        }
    
    #ifdef FOG
        #ifdef SUN
            float3 skyCol = skyColour.xyz - yInv*0.2*float3(1.0,0.5,1.0) + 0.15*0.5;        
            float sun = clamp(dot(lig,rd), 0.0, 1.0 );
            float3 fogCol = skyCol+sunIntensity*float3(1.0,.6,0.1)*pow(sun, 8.0 );  
            col = lerp( col, fogCol, 1.0-exp( -0.0001*fogIntensity*t*t*t ) );
        #else
            col = lerp( col, fogColour.xyz, 1.0-exp( -0.0001*fogIntensity*t*t*t ) );
        #endif
    #endif
    #ifdef SUN
        #ifdef SUNGLARE
        col += 0.2*float3(1.0,0.4,0.2)*pow( sun, 3.0 );
        #endif
    #else
        #ifdef SUNGLARE
        float sun = clamp(dot(lig,rd), 0.0, 1.0 );
        col += 0.2*float3(1.0,0.4,0.2)*pow( sun, 3.0 );
        #endif
    #endif
    col= float3( clamp(col,0.0,1.0) );
}

struct PS_OUT{
	float4 Color:SV_TARGET;
	float Depth:SV_DEPTH;
};
PS_OUT PS(VS_OUT In){
	
    float3 tot = 0.0;
#if AA > 1
    for( int m=0; m<AA; m++ )
		for( int n=0; n<AA; n++ )
    	{    	
        // pixel coordinates
        float2 o = AAradius*(float2(float(m),float(n)) / float(AA) - 0.5);
    	uv=In.TexCd.xy+o;
#else    
        uv=In.TexCd.xy;
#endif
		ro=mul(float4(0,0,0,1),tVI).xyz;
		rd=UVtoEYE(uv);
		
        render();
		// Tonemapping or GAMMA???
    	#ifdef TONEMAPPING
    		col=hejlToneMapping(float4 (col, 1.0) * EXPOSURE).xyz ;
    	#else
    		col = pow( col, GAMMA );
    	#endif
        tot += col;
#if AA>1
    	}
    	tot /= float(AA*AA);
#endif 

	float4 PosWVP=mul(float4(pos.xyz,1),tVP);
	PS_OUT Out;
	Out.Color=float4(tot,1.0);
	Out.Depth=(PosWVP.z)/PosWVP.w;
	return Out;
}