cbuffer cbLightData : register(b3)
{
	//light properties
	float3 lDir <string uiname="Light Direction";> = {0, -5, 2};        //light direction in world space
	float4 lAmb  <bool color=true; String uiname="Ambient Color";>  = {0.15, 0.15, 0.15, 1};
	float4 lSpec <bool color=true; String uiname="Specular Color";> = {0.35, 0.35, 0.35, 1};
	float lPower <String uiname="Power"; float uimin=0.0;> = 25.0;     //shininess of specular highlight
	//phong point
	float3 lPos <string uiname="Light Position";> = {0, 5, -2};       //light position in world space
	float lAtt0 <String uiname="Light Attenuation 0"; float uimin=0.0;> = 0;
	float lAtt1 <String uiname="Light Attenuation 1"; float uimin=0.0;> = 0.3;
	float lAtt2 <String uiname="Light Attenuation 2"; float uimin=0.0;> = 0;
}	float lRange <String uiname="Light Range"; float uimin=0.0;> = 10.0;

//phong directional function
float4 PhongDirectional(float3 NormV, float3 ViewDirV, float3 LightDirV)
{
	float4 amb = float4(lAmb.rgb, 1);
    //halfvector
    float3 H = normalize(ViewDirV + LightDirV);
    //compute blinn lighting
    float3 shades = lit(dot(NormV, LightDirV), dot(NormV, H), lPower).rgb;
    float4 diff = float4(col*shades.y, 1);
    diff.a = 1;
    //reflection vector (view space)
    float3 R = normalize(2 * dot(NormV, LightDirV) * NormV - LightDirV);
    //normalized view direction (view space)
    float3 V = normalize(ViewDirV);
    //calculate specular light
    float4 spec = pow(max(dot(R, V),0), lPower*.2) * lSpec;
    return (amb + diff) + spec;
}
//phong point function
float4 PhongPoint(float3 PosW, float3 NormV, float3 ViewDirV, float3 LightDirV)
{

    float d = distance(PosW, lPos);
    float atten = 0;

    //compute attenuation only if vertex within lightrange
    if (d<lRange)
    {
       atten = 1/(saturate(lAtt0) + saturate(lAtt1) * d + saturate(lAtt2) * pow(d, 2));
    }

    float4 amb = lAmb * atten;
    amb.a = 1;

    //halfvector
    float3 H = normalize(ViewDirV + LightDirV);

    //compute blinn lighting
    float4 shades = lit(dot(NormV, LightDirV), dot(NormV, H), lPower);

    float4 diff=0;
	diff.rgb = col * shades.y * atten;
    diff.a = 1;

    //reflection vector (view space)
    float3 R = normalize(2 * dot(NormV, LightDirV) * NormV - LightDirV);

    //normalized view direction (view space)
    float3 V = normalize(ViewDirV);

    //calculate specular light
    float4 spec = pow(max(dot(R, V),0), lPower*.2) * lSpec;

    return (amb + diff) + spec;
}
void render()
{ 
	float yInv = 1-rd.y;
	col = 1.0;
	#ifndef FOG
		col = skyColour.xyz - yInv*0.2*fogMult + 0.15*0.5;
		#ifdef SUN
			float sun = clamp(dot(lig,rd), 0.0, 1.0 );
			col += sunIntensity*float3(1.0,.6,0.1)*pow(sun, 8.0 );
		#endif
	#else
		
	#endif
    result = castRay(ro,rd);
    float t = result.x;
	float m = result.y;	
	
	if(m>0) // YEAH BROH YOU MADE IT YOU DREW SOME SHIT
    {
    	//pos is static to grab it below
       	pos = ro + t*rd;
        nor = 0;    	
          
        // material   		
   			nor = calcNormal(pos);
		#ifdef REFLECTION
            ref=0; 
            ref = reflect(rd, nor);
		#endif   	
    	
    	//col = 0.45 + 0.35*sin(float3(0.05,0.08,0.10)*(m-1.0));    
  	
		// lighitng   
    	#ifdef AMBIENTOCCLUSION
        	float occ = calcAO( pos, nor );
    	#else
    		float occ=1;
    	#endif

    	#ifdef BACKLIGHT
        	float bac = clamp( dot( nor, normalize(float3(-lig.x,0.0,-lig.z))), 0.0, 1.0 )*clamp( 1.0-pos.y,0.0,1.0);
    	#endif
    	
        #ifdef REFLECTION
    		float dom = smoothstep( -0.1, 0.1, ref.y );
    	#endif
    	
    	#ifdef FRESNEL
        	float fre = pow( clamp(1.0+dot(nor,rd),0.0,1.0), 2.0 );
    	#endif

		float3 lin = 0.0;
    	float3 LightDirV = normalize(mul(float4(lig,0.0f), mul(tW,tV)).xyz);
		float3 NormV = normalize(mul(mul(nor, (float3x3)tWIT),(float3x3)tV).xyz);
    	col = 0.45 + 0.35*sin(float3(0.05,0.08,0.10)*(m-1.0));
    	colourYourShit(m);
    	#ifdef PHONGDIR
		float3 phong = PhongDirectional(NormV,rd,LightDirV).xyz;    	
    	#else
    	float4 pos4=float4(pos,1);
    	float3 ViewDirV = -normalize(mul(pos4, tWV).xyz);
    	//float3 PosW = mul(pos4, tWL).xyz;
    	float3 phong = PhongPoint(pos,NormV, ViewDirV, LightDirV).rgb;
    	#endif
    	#ifdef SHADOWS
        	phong *= softshadow( pos, lig );
    	#endif
    	lin = phong;
    	
        //REFLECTION ON MODELS
    	#ifdef REFLECTION
    		#ifdef SHADOWS
    		dom *= softshadow( pos, ref );
    		#endif
        	lin += 0.50*dom*float3(0.40,0.60,1.00)*occ;
    	#endif
        //BACKLIGHT ?
    	#ifdef BACKLIGHT
        	lin += 0.50*bac*float3(0.25,0.25,0.25)*occ;
    	#endif
        //FRESNEL softner
    	#ifdef FRESNEL
        	lin += 0.25*fre*float3(1.00,1.00,1.00)*occ;
    	#endif
    	
		col = col*lin;
    }
	#ifdef FOG
        #ifdef SUN
            float3 skyCol = skyColour.xyz - yInv*0.2*float3(1.0,0.5,1.0) + 0.15*0.5;        
            float sun = clamp(dot(lig,rd), 0.0, 1.0 );
            float3 fogCol = skyCol+sunIntensity*float3(1.0,.6,0.1)*pow(sun, 8.0 );  
            col = lerp(col, fogCol, 1.0-exp( -0.0001*fogIntensity*t*t*t));
        #else
            col = lerp(col, fogColour.xyz, 1.0-exp( -0.0001*fogIntensity*t*t*t));
        #endif
    #endif
    #ifdef SUN
        #ifdef SUNGLARE
        col += 0.2*float3(1.0,0.4,0.2)*pow( sun, 3.0 );
        #endif
    #else
        #ifdef SUNGLARE
        float sun = clamp(dot(lig,rd), 0.0, 1.0 );
        col += 0.2*float3(1.0,0.4,0.2)*pow( sun, 3.0 );
        #endif
    #endif
	//YOUR FINAL PASS SHIT GOES HERE
	finalPassShit();
}

struct PS_OUT{
	float4 Color:SV_TARGET;
	float Depth:SV_DEPTH;
};
PS_OUT PS(VS_OUT In){
	
    float3 tot = 0.0;
#if AA > 1
    for( int m=0; m<AA; m++ )
		for( int n=0; n<AA; n++ )
    	{    	
        // pixel coordinates
        float2 o = AAradius*(float2(float(m),float(n)) / float(AA) - 0.5);
    	uv=In.TexCd.xy+o;
#else    
        uv=In.TexCd.xy;
#endif
		ro=mul(float4(0,0,0,1),tVI).xyz;
		rd=UVtoEYE(uv);
		#ifdef PHONGDIR
		render();
		#else
        render();
    	#endif
		// Tonemapping or GAMMA???
    	#ifdef TONEMAPPING
    		col=hejlToneMapping(float4 (col, 1.0) * EXPOSURE).xyz ;
    	#else
    		col = pow( col, GAMMA );
    	#endif
        tot += col;
#if AA>1
    	}
    	tot /= float(AA*AA);
#endif 

	float4 PosWVP=mul(float4(pos.xyz,1),tVP);
	PS_OUT Out;
	Out.Color=float4(tot,1.0);
	Out.Depth=(PosWVP.z)/PosWVP.w;
	return Out;
	//return float4( tot, 1.0 );
}