#ifndef STEPAMOUNT
	#define STEPAMOUNT 120
#endif
#ifndef STEPPRECISION
	#define STEPPRECISION 0.0001
#endif
#ifndef EXPOSURE
	#define EXPOSURE 0.7
#endif
#ifndef GAMMA
	#define GAMMA 0.4545
#endif

#define PI 3.14159265
#define TAU (2*PI)
#define PHI (sqrt(5)*0.5 + 0.5)

//////---------------------!!
////// Texture Sampler    //
//////--------------------!!

SamplerState textureSampler
{
	Filter = MIN_MAG_MIP_LINEAR;
	AddressU = Wrap;
	AddressV = Wrap;
};

//////---------------------!!
////// Serious magic here //	DON'T FUCK WITH IT BROH
//////--------------------!!	UNC MADE IT BROH

float3 r3d(float3 p,float3 z){z*=acos(-1)*2;float3 x=cos(z),y=sin(z);return mul(p,float3x3(x.y*x.z+y.x*y.y*y.z,-x.x*y.z,y.x*x.y*y.z-y.y*x.z,x.y*y.z-y.x*y.y*x.z,x.x*x.z,-y.y*y.z-y.x*x.y*x.z,x.x*y.y,y.x,x.x*x.y));}
float3x3 lookat(float3 dir,float3 up=float3(0,1,0)){float3 z=normalize(dir);float3 x=normalize(cross(up,z));float3 y=normalize(cross(z,x));return float3x3(x,y,z);} 
float3 UVtoEYE(float2 UV){return normalize(mul(float4(mul(float4((UV.xy*2-1)*float2(1,-1),0,1),tPI).xy,1,0),tVI).xyz);}

//////---------------------!!
////// Primitive functions // ADD YOUR PRIMITIVES HERE
//////--------------------!!

//All functions below are made by Inigo Quilez
//http://iquilezles.org/www/articles/distfunctions/distfunctions.htm

float sdPlane( float3 p ){return p.y;}
float sdSphere( float3 p, float s ){return length(p)-s;}
float sdTorus(float3 p, float2 t ){float2 q = float2(length(p.xz)-t.x,p.y);return length(q)-t.y;}
float sdBox( float3 p, float3 b )
{
    float3 d = abs(p) - b;
    return min(max(d.x,max(d.y,d.z)),0.0) + length(max(d,0.0));
}
float vmax(float3 v) {
	return max(max(v.x, v.y), v.z);
}
float cheapBox(float3 p, float3 b) {
	return vmax(abs(p) - b);
}
float sdEllipsoid( float3 p, float3 r )
{
    return (length( p/r ) - 1.0) * min(min(r.x,r.y),r.z);
}

float udRoundBox( float3 p, float3 b, float r )
{
    return length(max(abs(p)-b,0.0))-r;
}

float sdHexPrism( float3 p, float2 h )
{
    float3 q = abs(p);
    float d1 = q.z-h.y;
    float d2 = max((q.x*0.866025+q.y*0.5),q.y)-h.x;
    return length(max(float2(d1,d2),0.0)) + min(max(d1,d2), 0.);
}

float sdCapsule( float3 p, float3 a, float3 b, float r )
{
	float3 pa = p-a, ba = b-a;
	float h = clamp( dot(pa,ba)/dot(ba,ba), 0.0, 1.0 );
	return length( pa - ba*h ) - r;
}

float sdTriPrism( float3 p, float2 h )
{
    float3 q = abs(p);
    float d1 = q.z-h.y;
    float d2 = max(q.x*0.866025+p.y*0.5,-p.y)-h.x*0.5;
    return length(max(float2(d1,d2),0.0)) + min(max(d1,d2), 0.);
}

float sdCylinder( float3 p, float2 h )
{
  float2 d = abs(float2(length(p.xz),p.y)) - h;
  return min(max(d.x,d.y),0.0) + length(max(d,0.0));
}

float sdCone( float3 p, float3 c )
{
    float2 q = float2( length(p.xz), p.y );
    float d1 = -q.y-c.z;
    float d2 = max( dot(q,c.xy), q.y);
    return length(max(float2(d1,d2),0.0)) + min(max(d1,d2), 0.);
}

float sdConeSection( float3 p, float h, float r1, float r2 )
{
    float d1 = -p.y - h;
    float q = p.y - h;
    float si = 0.5*(r1-r2)/h;
    float d2 = max( sqrt( dot(p.xz,p.xz)*(1.0-si*si)) + q*si - r2, q );
    return length(max(float2(d1,d2),0.0)) + min(max(d1,d2), 0.);
}

float sdPyramid(float3 p, float3 h ) 
{
    float box = sdBox( p - float3(0,-2.0*h.z,0),2.0*h.z); 
    float d = 0.0;
    d = max( d, abs( dot(p, float3( -h.x, h.y, 0 )) ));
    d = max( d, abs( dot(p, float3(  h.x, h.y, 0 )) ));
    d = max( d, abs( dot(p, float3(  0, h.y, h.x )) ));
    d = max( d, abs( dot(p, float3(  0, h.y,-h.x )) ));
    float octa = d - h.z;
    return max(-box,octa);
 }

float length2( float2 p )
{
	return sqrt( p.x*p.x + p.y*p.y );
}

float length6( float2 p )
{
	p = p*p*p; p = p*p;
	return pow( p.x + p.y, 1.0/6.0 );
}

float length8( float2 p )
{
	p = p*p; p = p*p; p = p*p;
	return pow( p.x + p.y, 1.0/8.0 );
}

float sdTorus82( float3 p, float2 t )
{
    float2 q = float2(length2(p.xz)-t.x,p.y);
    return length8(q)-t.y;
}

float sdTorus88( float3 p, float2 t )
{
    float2 q = float2(length8(p.xz)-t.x,p.y);
    return length8(q)-t.y;
}

float sdCylinder6( float3 p, float2 h )
{
    return max( length6(p.xz)-h.x, abs(p.y)-h.y );
}

//////---------------------!!
////// Operation functions // 
//////--------------------!!

//Nearly all functions made by Inigo Quilez apart from polar by Mercury
//http://iquilezles.org/www/articles/distfunctions/distfunctions.htm

float3 opRep( float3 p, float3 c ){
   	float3 q = abs(fmod(p,c))-0.5*c;
    return q;
}
float opU( float d1, float d2 ){	return (d1<d2) ? d1 : d2;}
float2 opU( float2 d1, float2 d2 ){	return (d1.x<d2.x) ? d1 : d2;}
float opS( float d1, float d2 ){return max(-d1,d2);}
float2 opS( float2 d1, float2 d2 ){return float2(max(-d1.x,d2.x),(-d1.x>d2.x) ? d1.y : d2.y);}
float opI( float d1, float d2 ){
    return max(d1,d2);
}
float2 opI( float2 d1, float2 d2 )
{
    return float2(max(d1.x,d2.x),(d1.x>d2.x) ? d1.y : d2.y);
}

//polar repetition adapted from MERCURY demoscene group
//http://mercury.sexy/hg_sdf/

float3 opRepPolar(float3 p, float repetitions,float radius) {
	float angle = 2*PI/repetitions;
	float a = atan2(p.z, p.x) + angle/2.;
	float r = length(p);
	float c = floor(a/angle);
	a =abs(fmod(a,angle)) - angle/2.;
	p.xz = float2(cos(a), sin(a))*r;
	p-=  float3(radius,0.,0.);
	//TODO:
	// For an odd number of repetitions, fix cell index of the cell in -x direction
	// (cell index would be e.g. -5 and 5 in the two halves of the cell):
	//if (abs(c) >= (repetitions/2)) c = abs(c);
	return p;
}

//////--------------------------!!
////// Smooooooth Operatoooor   // 
//////-------------------------!!

//The following 3 functions are by Inigo Quilez
//http://www.iquilezles.org/www/articles/smin/smin.htm

// polynomial smooth min (k = 0.1); THIS IS CHEAPEST SMIN!!!
float opUsmin( float a, float b, float k )
{
    float h = clamp( 0.5+0.5*(b-a)/k, 0.0, 1.0 );
    return lerp( b, a, h ) - k*h*(1.0-h);
}
// exponential smooth min (k = 32);
float opUsminExp( float a, float b, float k )
{
    float res = exp( -k*a ) + exp( -k*b );
    return -log( res )/k;
}
// power smooth min (k = 8);
float opUsminPow( float a, float b, float k )
{
    a = pow( a, k ); b = pow( b, k );
    return pow( (a*b)/(a+b), 1.0/k );
}

//Super cool  union / intersect / substract functions by MERCURY demoscene group
//http://mercury.sexy/hg_sdf/
float opUstairs(float a, float b, float r, float n) {
	float s = r/n;
	float u = b-r;
	return min(min(a,b), 0.5 * (u + a + abs((abs(fmod (u - a + s, 2 * s))) - s)));
}
float opIstairs(float a, float b, float r, float n) {
	return -opUstairs(-a, -b, r, n);
}

float opSstairs(float a, float b, float r, float n) {
	return -opUstairs(-a, b, r, n);
}
float opIsmin(float a, float b, float r) {
	return -opUsmin(-a, -b, r);
}

float opSsmin(float a, float b, float r) {
	return -opUsmin(-a, b, r);
}

//////---------------------!!
////// Noise Functions    //	
//////--------------------!!	

//All functions made by Inigo Quilez
//http://www.iquilezles.org/www/articles/morenoise/morenoise.htm


float iqhash( float n )
{
	return frac(sin(n)*43758.5453);
	//OR, better: Dave Hoskins hash
	//BUT it's a bit slower... (no sin though)
	
	/*float3 p3  = frac(float3(n,n,n) * .1031);
    p3 += dot(p3, p3.yzx + 19.19);
    return frac((p3.x + p3.y) * p3.z);*/
}
float iqnoise(float3 x)
{
	float3 p = floor(x);
	float3 f = frac(x);	
	f = f*f*(3.0-2.0*f);
	float n = p.x + p.y*57.0 + 113.0*p.z;
	return lerp(lerp(lerp( iqhash(n+0.0  ), iqhash(n+1.0  ),f.x),
	lerp( iqhash(n+57.0 ), iqhash(n+58.0 ),f.x),f.y),
	lerp(lerp( iqhash(n+113.0), iqhash(n+114.0),f.x),
	lerp( iqhash(n+170.0), iqhash(n+171.0),f.x),f.y),f.z);
}

//TODO:
//Faster version of iqnoise which uses texture sampling and the little tex16.png texture from shadertoy

//////---------------------!!
////// Texture mapping     //	
//////--------------------!!	

Texture2D texDisp <string uiname="Displacement Texture";>;
Texture2D texColor <string uiname="Color Texture";>;
// spherical UVs taken from emh => https://www.shadertoy.com/view/MstXWS#
float2 sphericalUVs(float3 pos, float scale){
	float3 p = normalize(pos);
	return float2(.5+ atan2(p.x, p.z) / TAU, .5 - asin(p.y) / PI) * scale;
}

float3 tex3D( SamplerState samp, Texture2D tex, float3 p, float3 n,float scale ){
	n = max(abs(n) - .2, .001); //  etc.
    n /= (n.x + n.y + n.z );  
	p = (tex.Sample(samp,p.yz)*n.x+tex.Sample(samp,p.zx)*n.y+tex.Sample(samp,p.xy)*n.z).rgb;
	return p;	
}

//smooth tri-planar by XOR => https://www.shadertoy.com/view/Xd3XDS
float3 smoothTex3D( SamplerState samp, Texture2D tex, float3 p, float3 n,float scale ){
	return tex.Sample(samp,p.xy*scale).rgb*n.z*n.z+tex.Sample(samp,p.zy*scale).rgb*n.x*n.x+tex.Sample(samp,p.xz*scale).rgb*n.y*n.y;
}
float3 sphericalTex3D (SamplerState samp, Texture2D tex, float3 p, float scale){
	return tex.Sample(samp,sphericalUVs(p,scale)).rgb;
}

// Grey scale by Shane
float grey(float3 p){ return dot(p, float3(.299, .587, .114));}

// Texture bump mapping by Shane also
float3 bump( Texture2D tex, SamplerState samp, float3 p, float3 n, float bumpfactor,float scale)
{
 	const float2 pre = float2(0,1)*0.0001; 
	float3 nor = float3(smoothTex3D(samp,tex,p-pre.yxx,n,scale).x,
 					smoothTex3D(samp,tex,p-pre.xyx,n,scale).x,
 					 smoothTex3D(samp,tex,p-pre.xxy,n,scale).x)/pre.y;
 	nor -= smoothTex3D(samp,tex,p,n,scale).x/pre.y; 
 	nor -= n*dot(n,nor);
 	return normalize(n+nor*bumpfactor*cos(p.y*5));
}

#ifdef TONEMAPPING
float4 hejlToneMapping (float4 color) {
 	float4 x = max(0.0, color-0.004); 
	return (x * ((6.2*x)+0.5)) / max(x * ((6.2*x)+1.7)+0.06, 1e-8);
}
#endif

//FUCK VERTEX SHADERS BROH! PASS-THROUGH THE FUCKER!
struct VS_IN{float4 PosO:POSITION;float4 TexCd:TEXCOORD0;};
struct VS_OUT{float4 PosWVP:SV_POSITION;float4 TexCd:TEXCOORD0;};
VS_OUT VS(VS_IN In){VS_OUT Out=(VS_OUT)0;Out.TexCd=In.TexCd;Out.PosWVP=mul(float4(In.PosO.xy,0,1),tW);return Out;}
