//////---------------------!!
////// Volumetric clouds   //	https://www.shadertoy.com/view/XslGRr
//////--------------------!!	https://www.shadertoy.com/view/Xss3DS

float cloudRadius <string uiname="Cloud Radius";> =3.;
float3 cloudCenter <string uiname="Cloud Center";> = {0.,2.,0.};
float cloudDensityMult <string uiname="Cloud Density Multiplier";> =4.;
float cloudDensityScale <string uiname="Cloud Density Scale";> =1.5;
float cloudFeatherCut <string uiname="Cloud Feather Cut";> = 1.0;
float4 cloudColourStart <bool color=true;string uiname="Cloud Start Colour";> = { 1.1,0.99,0.88,1.0 }; 
float4 cloudColourEnd <bool color=true;string uiname="Cloud End Colour";> = { 0.4,0.15,0.1,1.0 };
float4 cloudColourInside <bool color=true;string uiname="Cloud Inside Colour";> = { 1.0,0.5,0.05,1.0 }; 
float4 cloudColourOutside <bool color=true;string uiname="Cloud Outside Colour";> = { 1.0,1.0,1.0,1.0 };
float cloudColorDivider <string uiname="Cloud Color Divider";> = 1.7;

float3 computeColour( float density, float radius ,float4 sceneCol)
{
	float3 result = lerp(cloudColourStart.rgb,cloudColourEnd.rgb, density );	
	result *= lerp( cloudColourInside.rgb,cloudColourOutside.rgb, min( (radius+.5)/cloudColorDivider, 1.0 ) );	
	return result;
}
float densityFn( float3 p, float r, out float rawDens, float rayAlpha,float res )
{
	float den = - 1.5*r;
    float t = time*.5;
    //float3 dir = float3(0.,1.,0.2);    
	float3 dir = float3(sin(p.y*0.5)/t*.5,1.,cos(p.y*0.5)/t*.5);
    float f;
    float3 q = cloudDensityScale*p - dir* t; f  = 0.50000*iqnoise( q );
	q = q*2.02 - dir* t; f += 0.25000*iqnoise( q );
	q = q*2.03 - dir* t; f += 0.12500*iqnoise( q );
	q = q*2.01 - dir* t; f += 0.06250*iqnoise( q );
	q = q*2.02 - dir* t; f += 0.03125*iqnoise( q );	
	// add noise with scale factor
	rawDens = den + (cloudDensityMult)*f;
	
    den = clamp( rawDens, 0.0, 1.0 );
	// thout the volume at the far extends of the bounding sphere to avoid clipping 
	den*=1.-smoothstep(0.8,1.,r/cloudRadius);    
 	den*=smoothstep(0.,cloudFeatherCut,res);
	//oden-= res;
	return den;
}
static float dens;
float4 fogMarch( float3 rayo, float3 rayd, float expInter, float2 fragCoord, float4 sceneCol)
{
    float4 sum = float4(0,0,0,0); float stepo = 0.05;     
    // dither start pos to break up aliasing
	float3 p = rayo + rayd * (expInter + stepo*iqnoise(fragCoord.xyx));	
    for( int i=0; i<64; i++ )
    {
        if( sum.a > 0.99 ) {break;}		
		float radiusFromExpCenter = length(p - cloudCenter);		
		if( radiusFromExpCenter > cloudRadius+0.01 ) break;
		
		float rawDens;
		float resu=mapClouds(p,cloudCenter);
        dens = densityFn( p, radiusFromExpCenter, rawDens, sum.a,resu );        
        float4 col = float4( computeColour(dens,radiusFromExpCenter,sceneCol), dens );		
        col.a *=0.8;        
       	col.rgb *= col.a;        
		sum = sum + col*(1.- sum.a);		
        float stepMult = 1. + 2.5*(1.-clamp(rawDens+1.,0.,1.));
		p += rayd * stepo * stepMult;
    	if( dens<0.1)continue;
    	pos = lerp(pos,p,dens); 
    }
    return clamp( lerp(sceneCol,sum/(0.001+sum.a),clamp(0.15+sum.a-(length(rayo-cloudCenter)*0.015),0.0,1.0)), 0.0, 1.0 );
}
// iq's sphere intersection
float iSphere(float3 ro, float3 rd, float4 sph)
{
	float3 oc = ro - sph.xyz; //distance ray orig- sphere center	
	float b = dot(oc, rd);
	float c = dot(oc, oc) - sph.w * sph.w; //sph.w is radius
	float h = b*b - c; // delta
	if(h < 0.0)	return -1.0;
	float t = (-b - sqrt(h)); //Agaa = 1.
	return t;
}