#region usings
using System;
using System.ComponentModel.Composition;
using System.Runtime.InteropServices;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using VVVV.Core.Logging;
#endregion usings
	
//using System;
using System.Diagnostics;
//using System.Windows.Forms;
//using System.Runtime.InteropServices;

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "KeyHook", Category = "System", Help = "Global key hook.", Tags = "", Author = "herbst")]
	#endregion PluginInfo
	public class ValueKeyboardHookNode : 
		IPluginEvaluate, 
		IPartImportsSatisfiedNotification,
		IDisposable
	{
		#region fields & pins
		[Input("Enable", IsSingle = true)]
		IDiffSpread<bool> FEnable;
		
		[Input("Block Keycodes")]
		ISpread<int> FIgnoreKeycodes;
		
		[Input("Window Handle", IsSingle = true)]
		IDiffSpread<int> FWindowHandle;
		
		[Output("Output")]
		ISpread<int> FKeys;
		
		//[Import()]
		//ILogger FLogger;
		#endregion fields & pins
		
		public void OnImportsSatisfied() {
			FKeys.SliceCount = 0;
		}
		
		public void Dispose() {
			UnsetHook();
		}
		
		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
			if(FEnable.IsChanged || FWindowHandle.IsChanged)
			{
				if(_hookID != IntPtr.Zero)
					UnsetHook();
				if(FEnable[0] && FWindowHandle.SliceCount > 0)
					SetHook(FWindowHandle[0]);
			}
			
			//FLogger.Log(LogType.Debug, "hi tty!");
		}
		
		private const int WH_KEYBOARD_LL = 13;
	    private const int WM_KEYDOWN = 0x0100;
		private const int WM_KEYUP = 0x0101;
		
	    private LowLevelKeyboardProc _proc;
	    private IntPtr _hookID = IntPtr.Zero;
		
		public void SetHook(int moduleHandle) {
			if((_proc) == null)_proc = HookCallback;
			if(_hookID != IntPtr.Zero)
				UnsetHook();
			
			_hookID = SetHook(_proc, moduleHandle);
			
			//FLogger.Log(LogType.Debug, "HookID: " + _hookID.ToInt32());
		}
		
		public void UnsetHook() {
			UnhookWindowsHookEx(_hookID);

			_hookID = IntPtr.Zero;
			//FLogger.Log(LogType.Debug, "Hook unhooked.");
		}
		private IntPtr windowHandle;

	    private IntPtr SetHook(LowLevelKeyboardProc proc, int moduleHandle)
	    {
	        using (Process curProcess = Process.GetCurrentProcess())
	        using (ProcessModule curModule = curProcess.MainModule)
	        {
	        	windowHandle = GetModuleHandle(curModule.ModuleName);
	        	//FLogger.Log(LogType.Debug, "Hook hooked.");
	        	return SetWindowsHookEx(
	        		WH_KEYBOARD_LL,
	        		proc,
	                windowHandle,
	        		0);
	        }
	    }
		
	    private delegate IntPtr LowLevelKeyboardProc(
	        int nCode, IntPtr wParam, IntPtr lParam);
	
		private void AddKey(int keyCode) {
			if(FKeys.IndexOf(keyCode) < 0)
			{
				FKeys.Add(keyCode);
				//FLogger.Log(LogType.Debug, "added " + keyCode);
			}	
		}
		
		private void RemoveKey(int keyCode) {
			FKeys.Remove(keyCode);
			//FLogger.Log(LogType.Debug, "removed " + keyCode);
		}
		
	    private IntPtr HookCallback(
	        int nCode, IntPtr wParam, IntPtr lParam)
	    {
	        if (
	    		nCode >= 0 &&
	    		(FWindowHandle[0] < 1 || (int)GetForegroundWindow() == FWindowHandle[0])
	    	)
	    	{
	    		int vkCode = Marshal.ReadInt32(lParam);
	    		
	    		// exchange special keys
				if(vkCode == 162 || vkCode == 163) vkCode = 17; // left ctrl + right ctrl
				if(vkCode == 160 || vkCode == 161) vkCode = 16; // left shift + right shift
				if(vkCode == 164) vkCode = 18;				   // alt
				
	    		
	    		// if(	wParam == (IntPtr)WM_KEYDOWN )
	    		
	    		
	    		if(FIgnoreKeycodes.IndexOf(vkCode) > -1)
	    			return (IntPtr)1;
	    		
	    		AddKey(vkCode);
	    		if( wParam == (IntPtr)WM_KEYUP )
	    			RemoveKey(vkCode);
	    		
	    	}
	        return CallNextHookEx(_hookID, nCode, wParam, lParam);
	    }
	
	    [DllImport("user32.dll", CharSet = CharSet.Auto, SetLastError = true)]
	    private static extern IntPtr SetWindowsHookEx(int idHook,
	        LowLevelKeyboardProc lpfn, IntPtr hMod, uint dwThreadId);
	
	    [DllImport("user32.dll", CharSet = CharSet.Auto, SetLastError = true)]
	    [return: MarshalAs(UnmanagedType.Bool)]
	    private static extern bool UnhookWindowsHookEx(IntPtr hhk);
	
	    [DllImport("user32.dll", CharSet = CharSet.Auto, SetLastError = true)]
	    private static extern IntPtr CallNextHookEx(IntPtr hhk, int nCode,
	        IntPtr wParam, IntPtr lParam);
	
	    [DllImport("kernel32.dll", CharSet = CharSet.Auto, SetLastError = true)]
	    private static extern IntPtr GetModuleHandle(string lpModuleName);
		
		[DllImport("user32.dll")]
		private static extern IntPtr GetForegroundWindow();
	}
}
