//@author: vvvv group
//@help: this is a very basic template. use it to start writing your own effects. if you want effects with lighting start from one of the GouraudXXXX or PhongXXXX effects
//@tags:
//@credits:

// --------------------------------------------------------------------------------------------------
// PARAMETERS:
// --------------------------------------------------------------------------------------------------

//transformsttytytytytytytytcyty
float4x4 tW: WORLD;        //the models world matrix
float4x4 tV: VIEW;         //view matrix as set via Renderer (EX9)
float4x4 tP: PROJECTION;
float4x4 tWVP: WORLDVIEWPROJECTION;

//texture
texture Tex <string uiname="Texture";>;
sampler Samp = sampler_state    //sampler for doing the texture-lookup
{
    Texture   = (Tex);          //apply a texture to the sampler
    MipFilter = POINT;         //sampler states
    MinFilter = POINT;
    MagFilter = POINT;
};

texture Tex2 <string uiname="Color Texture";>;
sampler Samp2 = sampler_state    //sampler for doing the texture-lookup
{
    Texture   = (Tex2);          //apply a texture to the sampler
    MipFilter = POINT;         //sampler states
    MinFilter = POINT;
    MagFilter = POINT;
};

//texture transformation marked with semantic TEXTUREMATRIX to achieve symmetric transformations
float4x4 tTex: TEXTUREMATRIX <string uiname="Texture Transform";>;

//the data structure: "vertexshader to pixelshader"
//used as output data with the VS function
//and as input data with the PS function
struct vs2ps
{
    float4 Pos  : POSITION; 
    //Position ist nicht verfügbr im pixelshader aber texcoords 
 
 	float2 TexCd : TEXCOORD0;
   // float Zett: TEXCOORD1; 
    //nehme texcoord1 als neue variable im int den pixelshader zu schreiben
};
// --------------------------------------------------------------------------------------------------
// VERTEXSHADERS
// --------------------------------------------------------------------------------------------------
float extrusion_factor = 1.5708;
float multiply_factor = 100;
vs2ps  VS_OpenNI(
    float4 PosO  : POSITION,
    float4 TexCd : TEXCOORD0
)
{
    //declare output struct
    vs2ps Out;
    TexCd = mul(TexCd, tTex); 
    float4 height = tex2Dlod (Samp,TexCd);
    //Out.Zett = (PosO.z - Min) / (Max-Min); //z position an pixelshader übergeben und auf Min Max mappen da hier schneller als pixelweise
	PosO.z = (tan(((height.z))*extrusion_factor))*multiply_factor;
 
	PosO.x *= PosO.z;
	PosO.y *= -PosO.z;
	//PosO.x *= PosO.z*0.9;
	//PosO.y *= -PosO.z*0.9;
	


    //transform position
	PosO = mul(PosO, tWVP);
    Out.Pos = PosO;

    //transform texturecoordinates
   Out.TexCd = TexCd;

    return Out;
}

vs2ps  VS_MSKinect (
    float4 PosO  : POSITION,
    float4 TexCd : TEXCOORD0
)
{
    //declare output struct
    vs2ps Out;
    TexCd = mul(TexCd, tTex); 
    float4 height =  tex2Dlod(Samp,TexCd);
    //Out.Zett = (PosO.z - Min) / (Max-Min); //z position an pixelshader übergeben und auf Min Max mappen da hier schneller als pixelweise
	PosO.z = (tan(((height.z))*extrusion_factor))*multiply_factor;
 
	PosO.x *= PosO.z;
	PosO.y *= -PosO.z;
	//PosO.x *= PosO.z*0.9;
	//PosO.y *= -PosO.z*0.9;
	


    //transform position
	PosO = mul(PosO, tWVP);
    Out.Pos = PosO;

    //transform texturecoordinates
   Out.TexCd = TexCd;

    return Out;
}
// --------------------------------------------------------------------------------------------------
// PIXELSHADERS:
// --------------------------------------------------------------------------------------------------

float4 PS(vs2ps In): COLOR
{
    float4 col = tex2D(Samp, In.TexCd);
	float4 col2 = tex2D(Samp, float2(In.TexCd.x+0.006,In.TexCd.y));
	float4 col3 = tex2D(Samp, float2(In.TexCd.x-0.006,In.TexCd.y));
    float4 col4 = tex2D(Samp, float2(In.TexCd.x,In.TexCd.y+0.006));
	float4 col5 = tex2D(Samp2, In.TexCd);
	col.r = (col2.r - col3.r)*300+0.5;
	col.g = (col4.r - col5.r)*300+0.5;
	col.b =col5.b*10; 
//	col.r = 1; col.b = 0; col.g = 1; 
    return col;
}

// --------------------------------------------------------------------------------------------------
// TECHNIQUES:
// --------------------------------------------------------------------------------------------------

technique T_OpenNI_PointCloud
{
    pass P0
    {
        //Wrap0 = U;  // useful when mesh is round like a sphere
        VertexShader = compile vs_3_0 VS_OpenNI();
        PixelShader  = compile ps_3_0 PS();
    }
}
technique T_MSKinect_PointCloud
{
    pass P0
    {
        //Wrap0 = U;  // useful when mesh is round like a sphere
        VertexShader = compile vs_3_0 VS_MSKinect();
        PixelShader  = compile ps_3_0 PS();
    }
}

technique TFixedFunction
{
    pass P0
    {
        //transforms
        WorldTransform[0]   = (tW);
        ViewTransform       = (tV);
        ProjectionTransform = (tP);

        //texturing
        Sampler[0] = (Samp);
        TextureTransform[0] = (tTex);
        TexCoordIndex[0] = 0;
        TextureTransformFlags[0] = COUNT2;
        //Wrap0 = U;  // useful when mesh is round like a sphere
        
        Lighting       = FALSE;

        //shaders
        VertexShader = NULL;
        PixelShader  = NULL;
    }
}
