#region usings
using System;
using System.ComponentModel.Composition;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using VVVV.Core.Logging;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "ColisionDetection", Category = "Value", Help = "Basic template with one value in/out", Tags = "")]
	#endregion PluginInfo
	public class ValueColisionDetectionNode : IPluginEvaluate
	{
		#region fields & pins
		// pole vstupnich  pozic
		[Input("Value XyzXyz", DefaultValue = 0.0)]
		ISpread<double> FInputValue;
		
		// nejmensi hodnoty v kazde krychli
		[Input("MinValue XyzXyz", DefaultValue = 0.0)]
		ISpread<double> FInputMinValue;	
		// nejvetsi hodnoty
		[Input("MaxValue XyzXyz", DefaultValue = 1.0)]
		ISpread<double> FInputMaxValue;	
		
		[Output("OutputHit")]
		ISpread<double> FOutputHit;

		[Output("OutputPoint")]
		ISpread<double> FOutputPoint;
		
		[Import()]
		ILogger FLogger;
		#endregion fields & pins

		//called when data for any output pin is requested
		public bool NEW = true;
		public void Evaluate(int SpreadMax)
		{
			int pocetBodu = FInputValue.SliceCount/3;
			int pocetBOXu = Math.Max(FInputMinValue.SliceCount/3,FInputMinValue.SliceCount/3);
			FOutputHit.SliceCount = pocetBOXu;

			for (int j=0; j<pocetBOXu; j++) {
				FOutputHit[j] = 0;
				for (int i = 0; i < pocetBodu; i++) {
					// probiram bod i, box j

					if ( (FInputValue[3*i  ]>FInputMinValue[3*j  ]) && (FInputValue[3*i  ]<FInputMaxValue[3*j  ]) &&
						 (FInputValue[3*i+1]>FInputMinValue[3*j+1]) && (FInputValue[3*i+1]<FInputMaxValue[3*j+1]) &&
						 (FInputValue[3*i+2]>FInputMinValue[3*j+2]) && (FInputValue[3*i+2]<FInputMaxValue[3*j+2])) {
						 FOutputHit[j] += 1;						
					}
				}
				
			}

			//FLogger.Log(LogType.Debug, "hi tty!");
		}
	}
}
