#region usings
using System;
using System.ComponentModel.Composition;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;



using VVVV.Utils.VColor;
using VVVV.Utils.VMath;
using VVVV.Core.Logging;

#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "CreatePointCloud", Category = "Value", Help = "Basic template with one value in/out", Tags = "")]
	#endregion PluginInfo
	public class ValueCreatePointCloudNode : IPluginEvaluate
	{
		
			#region fields & pins
		[Input("X", DefaultValue = 0.0)]
		ISpread<double> FInputX;

		[Input("Y", DefaultValue = 0.0)]
		ISpread<double> FInputY;
		[Input("Z", DefaultValue = 0.0)]
		ISpread<double> FInputZ;		


		
		[Output("OutputX")]
		ISpread<double> FOutputX;
		[Output("OutputY")]
		ISpread<double> FOutputY;
		[Output("OutputZ")]
		ISpread<double> FOutputZ;

		[Import()]
		ILogger FLogger;
		#endregion fields & pins

		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
			FOutputX.SliceCount = SpreadMax;
					FOutputY.SliceCount = SpreadMax;
					FOutputZ.SliceCount = SpreadMax;

			for (int i = 0; i < SpreadMax; i++) {

			FOutputZ[i] = (Math.Tan(((FInputZ[i]))*1.5708))*100;
			FOutputX[i] = (FInputX[i]*FOutputZ[i]);
			FOutputY[i] = (FInputY[i]*FOutputZ[i]);
			
		}
			
	  }
	}
}