//@author: vvvv group, tekcor
//@help: GPU LINES


// --------------------------------------------------------------------------------------------------
// PARAMETERS:
// --------------------------------------------------------------------------------------------------

//transforms
float4x4 tW: WORLD ;        //the models world matrix
float4x4 tP: PROJECTION ;
float4x4 tVP: VIEWPROJECTION ;
float4x4 tWV: WORLDVIEW ;
float4x4 tWVP: WORLDVIEWPROJECTION ;


//DataTexture Position 1
texture TexData1 <string uiname="Tex Position1";>;
sampler SampData1 = sampler_state    //sampler for doing the texture-lookup
{
    Texture   = (TexData1);          //apply a texture to the sampler
    MipFilter = none;         //sampler states
    MinFilter = none;
    MagFilter = none;
};

//DataTexture Position 2
texture TexData2 <string uiname="Tex Position2";>;
sampler SampData2 = sampler_state    //sampler for doing the texture-lookup
{
    Texture   = (TexData2);          //apply a texture to the sampler
    MipFilter = none;         //sampler states
    MinFilter = none;
    MagFilter = none;
};

//DataTexture Color
//Texture TexData2 <string uiname="Tex Rotation";>;
//sampler SampData2 = sampler_state
//{
//	Texture = (TexData2);
//	MipFilter = none;
//	MinFilter = none;
//	MagFilter = none;
//};

//DataTexture3
Texture TexData3 <string uiname="Tex Color";>;
sampler SampData3 = sampler_state
{
	Texture = (TexData3);
	MipFilter = none;
	MinFilter = none;
	MagFilter = none;
};

//the data structure: "vertexshader to pixelshader"
//used as output data with the VS function
//and as input data with the PS function

float Width<string uiname="Width";>;


struct vs2ps
{
    float4 Pos  : POSITION ;
    float4 ColorTex : TEXCOORD1 ;
	float4 TexCd2 : TEXCOORD3 ;
	float4 Vcol : Color ;

	float2 uv: TEXCOORD2;

};

// --------------------------------------------------------------------------------------------------
// VERTEXSHADERS
// --------------------------------------------------------------------------------------------------
vs2ps VS(
    float4 PosO  : POSITION ,
    float4 ColorTex : TEXCOORD1 ,
    float4 TexCd2 : TEXCOORD3 )
{  
	float w = Width * 0.003;
    //declare output struct
    vs2ps Out = (vs2ps)0;
	
	float u = PosO.x+0.5;
	Out.uv = float2(u, PosO.y*2);
	
    float4 p;
	
float3 Point1 = tex2Dlod(SampData1, TexCd2).xyz;	
float3 Point2 = tex2Dlod(SampData2, TexCd2).xyz;	
	
    float4 p1 = mul(float4(Point1, 1), tWVP);
    float4 p2 = mul(float4(Point2, 1), tWVP);	
	
    p = lerp(p1, p2, u);

    p1 /= p1.w;
    p2 /= p2.w;
    float4 tangent = p2 - p1;
	
    // get normal in projection space
    float2 normal = normalize(float2(tangent.y, -tangent.x));

    // translate point to get a thick curve
    float2 off = PosO.y * normal * w * p.w;

    off *= mul(float4(1, 1, 0, 0), tP);
	
    p+= float4(off, 0, 0);	

	Out.Pos = p;
    //Vertex Transformation from Data Texture
    //float3 Position = tex2Dlod(SampData1,TexCd2).xyz;
    //float3 rotate1 = -normalize(mul(PosO, tWV));
    //PosO.xyz = rotate(PosO.xyz, rotate1.x, rotate1.y, rotate1.z)+Position.xyz; 
	//PosO.xyz += Position.xyz;

	
	//Out.ViewDirV = -normalize(mul(PosO, tWV));
    //Out.Pos = mul(PosO, tWVP);
	Out.Vcol = tex2Dlod(SampData3, TexCd2);
	

    return Out;
}

// --------------------------------------------------------------------------------------------------
// PIXELSHADERS:
// --------------------------------------------------------------------------------------------------

float4 PS(vs2ps In): COLOR
{
	
	float4 col = In.Vcol; 
	return col;
}

// --------------------------------------------------------------------------------------------------
// TECHNIQUES:
// --------------------------------------------------------------------------------------------------

technique Simple
{
    pass P0
    {
        //Wrap0 = U;  // useful when mesh is round like a sphere
        VertexShader = compile vs_3_0 VS();
        PixelShader  = compile ps_3_0 PS();
    }
}
