#region usings
using System;
using System.ComponentModel.Composition;
using System.Collections.Generic; // we need to add this to use Lists .
using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using VVVV.Core.Logging;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "List&AssignFrom", Category = "Example", Help = "Basic template with one value in/out", Tags = "")]
	#endregion PluginInfo
	public class ExampleList_AssignFromNode : IPluginEvaluate
	{
		#region fields & pins
		// This is our Input pin to enter the spread . 
		[Input("Input", DefaultValue = 1)]
		ISpread<int> FInput;
		// This is our Add the spread pin 
		[Input("Add", DefaultValue = 0,IsSingle = true ,IsBang = true)]
		ISpread<bool> FAdd;
		// This is an extra pin to play a bit more with List 
		// and remove any number from the spread that is in the filter pin.
		[Input("Filter", DefaultValue = 0,IsSingle = true)]
		ISpread<int> FFilter;
		//This is the reset pin to clear the List 
		[Input("Reset", DefaultValue = 0,IsSingle = true ,IsBang = true)]
		ISpread<bool> FReset;
        // We output our calculation in the Output pin
		[Output("Output")]
		ISpread<int> FOutput;

		[Import()]
		ILogger FLogger;
		#endregion fields & pins
        // we make a new list and called it myList
		List<int> myList = new List<int>(); 
		

		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
			
			
			 // If the Pin Add is Bang the spread from the Input Pin gets in .
			if (FAdd[0])
			{
			  myList.Clear();// We clear the List here to start all over otherwise we,ll add a new spread each time we bang .
				
             // Here we get the spread from Input Pin in 
			 // so loop as many times as the size of the spread to get it
				
			for (int i = 0; i < FInput.SliceCount; i++)
			  {
				myList.Add(FInput[i]);
			  }
				
			//here we add some more logic ,If spread contains the value in the filter pin 
			//we remove all occurances in the spread of this value.
			if (myList.Contains(FFilter[0]))
			  {
			myList.RemoveAll(item => item == FFilter[0]);
			  }
				
			// some more we want to add a value on top of the list and at the end 
			myList.Insert(0,111);
				// To the begginig of the List
				//Note this is the whole list so if you add again another one will be place
			myList.Add(111);// to the end of the List
			}	
			
			
			
			 // We clear the List if the Reset Pin is bang 
			if (FReset[0])
			{
				myList.Clear();
			}
			
			// we set the SliceCount of our Output pin to be the same as size of the List .
			FOutput.SliceCount = myList.Count;
			//and Assign the data from our List to the Output Pin .
			FOutput.AssignFrom(myList); 
			
		}
	}
}
