//@author: woei
//@help: standard constant shader
//@tags: color

Texture2D texture2d <string uiname="Texture";>;
SamplerState linearSampler : IMMUTABLE
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Clamp;
    AddressV = Clamp;
};

cbuffer cbPerDraw : register( b0 )
{
	float4x4 tVP : VIEWPROJECTION;	
};

cbuffer cbPerObj : register( b1 )
{
	float4x4 tW : WORLD;
	float Alpha <float uimin=0.0; float uimax=1.0;> = 1; 
	float4 cAmb <bool color=true;String uiname="Color";> = { 1.0f,1.0f,1.0f,1.0f };
	float4x4 tTex <string uiname="Texture Transform"; bool uvspace=true; >;
	float f <string uiname="Feather"; float uimin=0.0; float uimax=1.0;>;
	float ht <string uiname="Helper Thickness"; float uimin=0.0; float uimax=1.0;> = 0.1;
};

struct VS_IN
{
	float4 PosO : POSITION;
	float4 TexCd : TEXCOORD0;

};

struct vs2ps
{
    float4 PosWVP: SV_POSITION;
    float4 TexCd: TEXCOORD0;
	float2 uv : TEXCOORD1;
};

vs2ps VS(VS_IN input)
{
    vs2ps output;
    output.PosWVP  = mul(input.PosO,mul(tW,tVP));
	output.uv = input.TexCd.xy;
    output.TexCd = mul(input.TexCd,tTex);
    return output;
}

float4 PS_Draw(vs2ps In): SV_Target
{
    float4 col = texture2d.Sample(linearSampler,In.TexCd.xy) * cAmb;
	float r = distance(In.uv, float2(0.5,0.5))*2.01;
	col.a *= smoothstep(1,1-f-1.000e-007,r);
    return col;
}

float4 PS_Helper(vs2ps In): SV_Target
{
    float4 col = texture2d.Sample(linearSampler,In.TexCd.xy) * cAmb;
	float r = distance(In.uv, float2(0.5,0.5))*2.01;
	float _w = ht*0.5;
	float outer = smoothstep(1+_w,1,r)*smoothstep(1-_w,1,r)*0.5;
	float inner = 1-f-1.000e-007;
	inner = smoothstep(inner+_w,inner,r)*smoothstep(inner-_w,inner,r);
	col.a *= max(inner,outer);
    return col;
}


technique10 Draw
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, PS_Draw() ) );
		
	}
}
technique10 Helper
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, PS_Helper() ) );
		
	}
}




