//@author: woei
//@help: 10 controlpoints as cosine spline, phong lightning with point light
//@tags: shading, blinn
// PARAMETERS ------------------------------------------------------------------
//transforms
float4x4 tW: WORLD;        //the models world matrix
float4x4 tV: VIEW;         //view matrix as set via Renderer (DX9)
float4x4 tWV: WORLDVIEW;
float4x4 tWVP: WORLDVIEWPROJECTION;
float4x4 tP: PROJECTION;   //projection matrix as set via Renderer (DX9)

#include "PhongPoint.fxh"

Texture2D texture2d <string uiname="Texture"; >; 
SamplerState g_samLinear
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Clamp;
    AddressV = Clamp;
};

static const int RES = 10;
struct spline_points {
	float4 pts[RES];
};

StructuredBuffer<spline_points> spline;
struct vs2ps
{
    float4 PosWVP: SV_POSITION;
    float4 TexCd : TEXCOORD0;
    float3 LightDirV: TEXCOORD1;
    float3 NormV: TEXCOORD2;
    float3 ViewDirV: TEXCOORD3;
    float3 PosW: TEXCOORD4;
};
// VERTEXSHADERS ---------------------------------------------------------------
float3x3 rotationAlign(float3 d, float3 z)
{
    float3  v = cross( z, d );
    float c = dot( z, d );
    float k = 1.0f/(1.0f+c);

    return float3x3( v.x*v.x*k + c,     v.y*v.x*k - v.z,    v.z*v.x*k + v.y,
                   v.x*v.y*k + v.z,   v.y*v.y*k + c,      v.z*v.y*k - v.x,
                   v.x*v.z*k - v.y,   v.y*v.z*k + v.x,    v.z*v.z*k + c    );
}

float4 cosine(float4 p1, float4 p2, float x)
{
	x = (1-cos(x*3.14159))/2;
	return (p1*(1-x)+p2*x);
}

int ppI = 5;
vs2ps VS(
	uint ii : SV_InstanceID,
    float4 PosO: POSITION,
    float3 NormO: NORMAL,
    float4 TexCd : TEXCOORD0)
{
    //inititalize all fields of output struct with 0
    vs2ps Out = (vs2ps)0;

	float4 pts[RES] = spline[ii];
	
	float2 range = TexCd.yx*float2(-1,1);
	float width = length(PosO.xz);
	
	float4 interp = (PosO.y+0.5)*(RES-1.0);
	interp.zw += 0.01; //little offset to calculate tangents
	interp.xz = floor(interp.xz);
	interp.yw = frac(interp.yw);
	
	float4 curve = cosine(pts[interp.x],pts[interp.x+1],interp.y);
	float4 _curve = cosine(pts[interp.z],pts[interp.z+1],interp.w);
	
	PosO.xyz = curve.xyz;
	float3 tang = _curve.xyz - PosO.xyz;
	float3x3 r = rotationAlign(float3(0,1,0),normalize(tang));
	NormO = mul(NormO,r);
	
	PosO.xyz += NormO*width*curve.w;
    Out.PosW = mul(PosO, tW).xyz;

    //inverse light direction in view space
    float3 LightDirW = normalize(lPos - Out.PosW);
    Out.LightDirV = mul(float4(LightDirW,0.0f), tV).xyz;
    
    //normal in view space
    Out.NormV = normalize(mul(float4(NormO,0.0f), tWV).xyz);

    //position (projected)
    Out.PosWVP  = mul(PosO, tWVP);
    Out.TexCd = TexCd;
    Out.ViewDirV = -normalize(mul(PosO, tWV).xyz);
    return Out;
}
// PIXELSHADERS ----------------------------------------------------------------
float Alpha <float uimin=0.0; float uimax=1.0;> = 1;

float4 PS(vs2ps In): SV_Target
{
    float4 col = texture2d.Sample(g_samLinear, In.TexCd.xy);

    col.rgb *= PhongPoint(In.PosW, In.NormV, In.ViewDirV, In.LightDirV).rgb;
    col.a *= Alpha;
    return col;
}
// TECHNIQUES ------------------------------------------------------------------
technique10 TPhongPoint
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, PS() ) );
	}
}

