
#include "PhongMulti.fxh"

struct vsInput
{
    float4 posObject : POSITION;
	float4 normalObject : NORMAL;
};

struct psInput
{
    float4 posScreen : SV_Position;
    float3 NormV: TEXCOORD0;
    float3 ViewDirV: TEXCOORD1;
    float3 PosW: TEXCOORD2;
};

struct vsInputTextured
{
    float4 posObject : POSITION;
	float4 normalObject : NORMAL;
	float4 uv: TEXCOORD0;
};

struct psInputTextured
{
    float4 posScreen : SV_Position;
    float4 uv: TEXCOORD0;
    float3 NormV: TEXCOORD1;
    float3 ViewDirV: TEXCOORD2;
	float3 PosW: TEXCOORD3;
};

Texture2D inputTexture <string uiname="Texture";>;

SamplerState linearSampler <string uiname="Sampler State";>
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Clamp;
    AddressV = Clamp;
}; 

cbuffer cbPerDraw : register(b0)
{
	float4x4 tV: VIEW;
	float4x4 tP: PROJECTION;
	float4x4 tVP: VIEWPROJECTION;
};

cbuffer cbPerObj : register( b1 )
{
	float4x4 tW : WORLD;
	float4x4 tWV: WORLDVIEW;
	float4x4 tWIT: WORLDINVERSETRANSPOSE;
	
	float Alpha <float uimin=0.0; float uimax=1.0;> = 1; 
	float4 cAmb <bool color=true;String uiname="Color";> = { 1.0f,1.0f,1.0f,1.0f };
	float4x4 tColor <string uiname="Color Transform";>;
};

cbuffer cbTextureData : register(b2)
{
	float4x4 tTex <string uiname="Texture Transform"; bool uvspace=true; >;
};

psInputTextured VS
(
    float4 PosO: POSITION,
    float3 NormO: NORMAL,
    float4 TexCd : TEXCOORD0)
{
    psInputTextured output;

    output.PosW = mul(PosO, tW).xyz;
    
    //normal in view space
    output.NormV = normalize(mul(mul(NormO, (float3x3)tWIT),(float3x3)tV).xyz);

    //position (projected)
    output.posScreen  = mul(PosO, mul(tW,tVP));
    output.uv = mul(TexCd, tTex);
    output.ViewDirV = -normalize(mul(PosO, tWV).xyz);
    return output;
}

psInput VS_NoTexture
(
    float4 PosO: POSITION,
    float3 NormO: NORMAL)
{
    psInput output;

    output.PosW = mul(PosO, tW).xyz;

    //normal in view space
    output.NormV = normalize(mul(mul(NormO, (float3x3)tWIT),(float3x3)tV).xyz);

    //position (projected)
    output.posScreen  = mul(PosO, mul(tW,tVP));
    output.ViewDirV = -normalize(mul(PosO, tWV).xyz);
    return output;
}


float4 PS(psInputTextured input): SV_Target
{
    float4 col = inputTexture.Sample(linearSampler, input.uv.xy) * cAmb;
	
	uint lPosDirCount, dummy;
    lPosDirBuffer.GetDimensions(lPosDirCount, dummy);
	uint lTypeCount;
    lTypeBuffer.GetDimensions(lTypeCount, dummy);
	
	float4 colLight = 0;
	for(uint i = 0; i < lPosDirCount; i++){
		switch (lTypeBuffer[i % lTypeCount]){
			case 0:
				colLight += MultiPhongPoint(i, input.PosW, input.NormV, input.ViewDirV, tV, 0);
				break;
			case 1:
				colLight += MultiPhongDirectional(i, input.NormV, input.ViewDirV, tV, 0);
				break;
		}
	}
	col.a *= Alpha;
    return  mul(col * colLight, tColor);	
}

float4 PS_NoTexture(psInput input): SV_Target
{
    float4 col = cAmb;
    uint lPosDirCount, dummy;
    lPosDirBuffer.GetDimensions(lPosDirCount, dummy);
	uint lTypeCount;
    lTypeBuffer.GetDimensions(lTypeCount, dummy);
	
	float4 colLight = 0;
	for(uint i = 0; i < lPosDirCount; i++){
		switch (lTypeBuffer[i % lTypeCount]){
			case 0:
				colLight += MultiPhongPoint(i, input.PosW, input.NormV, input.ViewDirV, tV, 0);
				break;
			case 1:
				colLight += MultiPhongDirectional(i, input.NormV, input.ViewDirV, tV, 0);
				break;
		}		
	}
	col.a *= Alpha;
	return col * colLight;
    //return  mul(col * colLight, tColor);
}


technique10 PhongMulti <string noTexCdFallback="PhongMulti_NoTexture"; >
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_5_0, PS() ) );
	}
}

technique10 PhongMulti_NoTexture
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS_NoTexture() ) );
		SetPixelShader( CompileShader( ps_5_0, PS_NoTexture() ) );
	}
}


