#region usings
using System;
using System.ComponentModel.Composition;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using VVVV.Core.Logging;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "DragFixed", Category = "Value",
	Help = "",Tags = "mouse, slider", AutoEvaluate = true)]
	#endregion PluginInfo
	public class ValueDragFixedNode : IPluginEvaluate
	{
		#region fields & pins
		[Input("Input", DefaultValue = 0.0)]
		ISpread<double> FInput;

		[Input("Button", DefaultValue = 0.0)]
		ISpread<bool> FButton;

		[Input("Initialize", DefaultValue = 0.0, IsBang = true)]
		ISpread<bool> FInit;

		[Input("Default", DefaultValue = 0.0)]
		ISpread<double> FInitValue;

		[Output("Output")]
		ISpread<double> FOutput;

		// is this the dirty or the normal way to store input values inbetween frames?
		[Output("LastFrameValue",DefaultValue = 0.0)]
		ISpread<double> LastFrameValue;
		#endregion fields & pins

		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
			FOutput.SliceCount = SpreadMax;
			LastFrameValue.SliceCount = SpreadMax;

			for (int i = 0; i < SpreadMax; i++) {
				double currentInput = FInput[i % (FInput.SliceCount)];
				bool currentButton = FButton[i % (FButton.SliceCount)];
				bool currentInit = FInit[i % (FInit.SliceCount)];
				double currentInitValue = FInitValue[i % (FInitValue.SliceCount)];

				
				//////Reset InitValue
				if (currentInit) {
					FOutput[i] = currentInitValue;
					/////Apply Drag Relative Value
				} else if (currentButton) {
					FOutput[i] += currentInput - LastFrameValue[i];
				}
				LastFrameValue[i] = currentInput;
			}
		}
	}
}
