#region usings
using System;
using System.Runtime.InteropServices;
using System.ComponentModel.Composition;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;
using VVVV.Core.Logging;

using NAudio.Wave;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "AudioTester",
	Category = "NAudio",
	Help = "Basic Tester for the NAudio engine",
	Tags = "",
	AutoEvaluate = true)]
	#endregion PluginInfo
	public class NAudioAudioTesterNode : IPluginEvaluate, IDisposable
	{
		#region fields & pins
		[Input("Filename", StringType = StringType.Filename)]
		IDiffSpread<string> FFilename;
		
		[Input("Restart", IsBang=true)]
		ISpread<bool> FRestart;
		
		[Input("Play")]
		IDiffSpread<bool> FPlay;
		
		private AsioOut FDriver;
		private WaveStream FStream;
		
		[Import()]
		ILogger FLogger;
		#endregion fields & pins
		
		public NAudioAudioTesterNode()
		{ 
			FDriver = new AsioOut();
		}
		
		public void Dispose()
		{
			FDriver.Dispose();
		}
		
		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
			bool needsInit = false;
			if (FFilename.IsChanged)
			{
				FStream = new WaveFileReader(FFilename[0]);
		    	FStream = new WaveChannel32(FStream);
		    	FDriver.Init(FStream);
				needsInit = true;
			}
			
			if (FRestart[0])
				FStream.CurrentTime = TimeSpan.FromSeconds(0);
			
			if (FPlay.IsChanged || needsInit)
				if (FPlay[0])
					FDriver.Play();
				else
					FDriver.Stop();
		}
	}
}
