#region usings
using System;
using System.IO;
using System.ComponentModel.Composition;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using VVVV.Core.Logging;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "RGB", Category = "Join", Help = "Join Color", Tags = "Teensy WS2811")]
	#endregion PluginInfo
	public class JoinRGBNode : IPluginEvaluate, IPartImportsSatisfiedNotification
	{
		#region fields & pins
		[Input("Red")]
		public ISpread<Stream> FRed;
		
		[Input("Green")]
		public ISpread<Stream> FGreen;

		[Input("Blue")]
		public ISpread<Stream> FBlue;
		
		[Input("LED Count", DefaultValue = 128, IsSingle = true)]
		public ISpread<int> FLedCount;

		[Output("Output")]
		public ISpread<Stream> FOutput;

		[Import()]
		public ILogger FLogger;
		private byte[] Buffer = new byte[8];
		
		#endregion fields & pins
		
		public void OnImportsSatisfied()
		{
			//start with an empty stream output
			FOutput.SliceCount = 0;
		}			

		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
			SpreadMax = Math.Max(FRed.SliceCount, Math.Max(FGreen.SliceCount, FBlue.SliceCount));
			
			FOutput.ResizeAndDispose(SpreadMax, () => new MemoryStream());

			Stream[] input = new Stream[3];
			MemoryStream output;
			
			for (int teensy = 0; teensy < SpreadMax; teensy++) {
				output = (MemoryStream)FOutput[teensy];
				output.Seek(0, SeekOrigin.Begin);
				output.SetLength(3 * 8 * FLedCount[0]); // 3 Colors, 8 pins with count LED each
				
				input[0] = FRed[teensy];
				input[1] = FGreen[teensy];
				input[2] = FBlue[teensy];
				
				for (int i=0;i<3;i++) input[i].Seek(0, SeekOrigin.Begin);
				
				// it is always 8 byte of red, then 8 byte of green and 8 byte of blue
				for (int led = 0;led<FLedCount[0]*8 / 8;led++) {
					for (int color = 0;color<3;color++) {
						input[color].Read(Buffer, 0, 8);
						output.Write(Buffer, 0, 8);
					}
				}
				output.Flush();
			}
	//		FOutput.Flush();
				
		}
	}
}
