#region usings
using System;
using System.IO;
using System.ComponentModel.Composition;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using VVVV.Core.Logging;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "Add", Category = "Raw", Version = "", Help = "Add multiple Raw streams to one", Tags = "Spectral, velcrome")]
	#endregion PluginInfo
	public class SpectralRawAddNode : IPluginEvaluate, IPartImportsSatisfiedNotification
	{
		#region fields & pins
		[Input("Input")]
		public ISpread<ISpread<Stream>> FInput;

		[Output("Output")]
		public ISpread<Stream> FOutput;

		[Import()]
		public ILogger Flogger;
		#endregion fields & pins

		//called when all inputs and outputs defined above are assigned from the host
		public void OnImportsSatisfied()
		{
			//start with an empty stream output
			FOutput.SliceCount = 0;
		}		
		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
			SpreadMax = FInput.SliceCount;
			FOutput.ResizeAndDispose(SpreadMax, () => new MemoryStream());

			for (int i = 0; i < SpreadMax; i++) {
			//	FOutput[i].Position = 0;
				FOutput[i].Seek(0, SeekOrigin.Begin);
				
				for (int j = 0; j < FInput[i].SliceCount; j++) {
					FInput[i][j].Seek(0, SeekOrigin.Begin);
					FInput[i][j].CopyTo(FOutput[i]);
					
				}
			}
			FOutput.Flush();
		}
	}
}
