#region usings
using System;
using System.IO;
using System.ComponentModel.Composition;
using System.Collections.Generic;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using VVVV.Core.Logging;

#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "Octofy", Category = "WS2811", Help = "Basic template with one value in/out", Tags = "")]
	#endregion PluginInfo
	public class WS2811OctofyNode : IPluginEvaluate, IPartImportsSatisfiedNotification
	{
		#region fields & pins
		[Input("Input")]
		public ISpread<Stream> FInput;
		
		[Input("Strip Length", DefaultValue = 128.0, IsSingle = true)]
		public ISpread<int> FLength;

		[Output("Output")]
		public ISpread<Stream> FOutput;

		//when dealing with byte streams (what we call Raw in the GUI) it's always
		//good to have a byte buffer around. we'll use it when copying the data.
		byte[] FBuffer = new byte[StripeLength*8];
		const int StripeLength = 128;
		
		[Import()]
		public ILogger FLogger;
		#endregion fields & pins

		public void OnImportsSatisfied()
		{
			//start with an empty stream output
			FOutput.SliceCount = 0;
		}		
		
		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
			SpreadMax = FInput.SliceCount; // TeensyCount
			FOutput.ResizeAndDispose(SpreadMax, () => new MemoryStream());
			
			int numBytesToCopy = StripeLength*8;

			for (int teensy = 0; teensy < SpreadMax; teensy++) { // one teensy at a time
				var output = FOutput[teensy];
				output.Seek(0, SeekOrigin.Begin);
				output.SetLength(numBytesToCopy);

				var input = FInput[teensy];
				input.Seek(0, SeekOrigin.Begin);
				input.Read(FBuffer, 0, StripeLength * 8); // read to array
			
				
	//			FLogger.Log(LogType.Debug, "===");

				byte mask = 0;
				byte[] pwm = new byte[8];

				for (int col = 0;col<StripeLength;col++) {
					for (byte bit = 0;bit<8;bit++) {
						mask = (byte)(1 << bit);
						pwm[7-bit] = 0;
					
						for (byte pin = 0;pin<8;pin++) {
							var led = FBuffer[StripeLength*pin + col];
							
							pwm[7-bit] += (byte)(((led & mask) >> bit) << pin);
						}
					}

					output.Write(pwm, 0, 8); // this is not correct! collect 8 pwms and reverse their order before writing to stream!
				}
				
			}
			
		}
	}
}
