#region usings
using System;
using System.IO;
using System.ComponentModel.Composition;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;
using VVVV.Utils.Streams;

using VVVV.Core.Logging;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "Add", Category = "Raw", Version = "Working", Help = "Basic raw template which copies up to count bytes from the input to the output", Tags = "")]
	#endregion PluginInfo
	public class WorkingRawAddNode : IPluginEvaluate, IPartImportsSatisfiedNotification
	{
		#region fields & pins
		[Input("Input 1")]
        public ISpread<Stream> FInput1;

		[Input("Input 2")]
        public ISpread<Stream> FInput2;

		
		[Output("Output")]
		public ISpread<Stream> FOutput;

		#endregion fields & pins

		//called when all inputs and outputs defined above are assigned from the host

		public void OnImportsSatisfied()
		{
			FOutput.SliceCount  = 0;
		}
		
		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
			SpreadMax = Math.Max(FInput1.SliceCount, FInput2.SliceCount);
			FOutput.ResizeAndDispose(SpreadMax, () => new MemoryStream());

			for (int i = 0; i < SpreadMax; i++) {
				FOutput[i].Position = 0;
				
				FInput1[i].Position = 0;
				FInput1[i].CopyTo(FOutput[i]);
					
				FInput2[i].Position = 0;
				FInput2[i].CopyTo(FOutput[i]);

			}

			FOutput.Flush();
		}
	}
}
