//@author: vvvv group
//@help: this is a very basic template. use it to start writing your own effects. if you want effects with lighting start from one of the GouraudXXXX or PhongXXXX effects
//@tags:
//@credits:

// --------------------------------------------------------------------------------------------------
// PARAMETERS:
// --------------------------------------------------------------------------------------------------

//transforms
float4x4 tW: WORLD;        //the models world matrix
float4x4 tV: VIEW;         //view matrix as set via Renderer (EX9)
float4x4 tP: PROJECTION;
float4x4 tWVP: WORLDVIEWPROJECTION;

//texture
texture Tex <string uiname="Texture";>;
sampler Samp = sampler_state    //sampler for doing the texture-lookup
{
    Texture   = (Tex);          //apply a texture to the sampler
    MipFilter = LINEAR;         //sampler states
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};

//the data structure: "vertexshader to pixelshader"
//used as output data with the VS function
//and as input data with the PS function
struct appdata_img {
    float4 vertex : POSITION;
    half2 texcoord : TEXCOORD0;
};

struct v2f 
{
	float4 pos : POSITION;
	float2 uv : TEXCOORD0;
};

float2 _Center 					= float2(0,0);
float2 _ScaleIn 				= float2(0,0);
float2 _Scale  					= float2(0,0);
float4 _HmdWarpParam 			= float4(0,0,0,0);
float4 _ChromaticAberration 	= float4(0,0,0,0);
	

// --------------------------------------------------------------------------------------------------
// VERTEXSHADERS
// --------------------------------------------------------------------------------------------------
v2f vert( appdata_img v ) 
{
	v2f o;
	o.pos = mul(tWVP, v.vertex);
	o.uv = v.texcoord.xy;
	return o;
} 

// --------------------------------------------------------------------------------------------------
// PIXELSHADERS:
// --------------------------------------------------------------------------------------------------

half4 frag(v2f i) : COLOR 
{
    // calculate normal distortion values
	float2 theta  = (i.uv - _Center) * _ScaleIn; 
	float  rSq    = theta.x * theta.x + theta.y * theta.y;
	float2 theta1 = theta * (_HmdWarpParam.x + 
							 _HmdWarpParam.y * rSq + 
    	                     _HmdWarpParam.z * rSq * rSq + 
       	                 	 _HmdWarpParam.w * rSq * rSq * rSq);
       	               
    // calculate the texture co-ordinates for each color channel  	 
    float2 thetaRed  = (theta1 * _ChromaticAberration.x) + 
		              (theta1 * rSq * _ChromaticAberration.y);
	float2 tcRed     = _Center + _Scale * thetaRed;

    float2 tcGreen   = _Center + _Scale * theta1;

	float2 thetaBlue = (theta1 * _ChromaticAberration.z) + 
	                   (theta1 * rSq * _ChromaticAberration.w);
	float2 tcBlue    = _Center + _Scale * thetaBlue;

	// Check to see if we are out of range on the texture co-ordinates
	// (green channel is the same as normal distortion)

	// Using 3 different texture co-ordinates, sample each channel
	// to correct for color aberration
	half red   = tex2D (Samp, tcRed).x;
	half green = tex2D (Samp, tcGreen).y;    
	half blue  = tex2D (Samp, tcBlue).z;
	half alpha = 1;
	
	//float red = tex2D (_MainTex, i.uv + float2(0.1, 0.0)).x;;
	//float green = tex2D (_MainTex, i.uv).y;
	//float blue = tex2D (_MainTex, i.uv + float2(0.0, 0.1)).z;;
	//float alpha = 1;
	
	if (any(clamp(tcGreen, float2(0, 0), float2(1, 1)) - tcGreen))
	{
    	red   = 0;
		green = 0;    
		blue  = 0;
		alpha = 0;
	}
	return half4(red, green, blue, alpha);  	  		

}

// --------------------------------------------------------------------------------------------------
// TECHNIQUES:
// --------------------------------------------------------------------------------------------------

technique TSimpleShader
{
    pass P0
    {
        //Wrap0 = U;  // useful when mesh is round like a sphere
        VertexShader = compile vs_2_0 vert();
        PixelShader  = compile ps_2_0 frag();
    }
}