﻿
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using OculusSharp.CAPI;


namespace VVVV.Nodes
{

    class OVRDevice
    {

        Hmd hmd;
        bool initialized;

        public void init()
        {
            initialized = Hmd.Initialize();
            
            if (Hmd.DetectHmd() > 0)
            {
               hmd = new Hmd(0);
            }
            else
                hmd = new Hmd(HmdType.Hmd_DK2);

            hmd.ConfigureTracking(TrackingCap.TrackingCap_Orientation | TrackingCap.TrackingCap_MagYawCorrection | TrackingCap.TrackingCap_Position | TrackingCap.TrackingCap_Idle, TrackingCap.TrackingCap_Orientation);
            

            Vector3f v;
            
           
        }


        Posef trackerData;

        public Quatf GetOrientation()
        {
          
            trackerData = hmd.GetEyePose(EyeType.Eye_Left);
            
            Quatf qf = trackerData.Orientation;

            return qf;

        }

        public Vector3f getPos()
        {

            trackerData = hmd.GetEyePose(EyeType.Eye_Left);

            Vector3f pos = trackerData.Position;

            return pos;
        }


        public void clear()
        {
            hmd.Dispose();
            Hmd.Shutdown();
        }


        public override string ToString()
        {

            return hmd.ToString();

        }
    }
}
