#region usings

using OculusSharp;
using System;
using System.ComponentModel.Composition;
using VVVV.Core.Logging;
using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "OVRDevice", Category = "Value", Version = "1", Help = "ovrdevicve", Tags = "")]
	#endregion PluginInfo
	public class template : IPluginEvaluate
	{
		
        #region fields & pins
		
       
       [Output("N-Position")]
       ISpread<Vector3D> position;

       //[Input("N-GetTimeTrigger", IsBang = true, IsSingle = true)]
       //IDiffSpread<bool> FGetTimeTrigger;

		

        //------from original dk

        [Input("Enabled")]
        IDiffSpread<bool> FEnabled;

        
        [Output("Output")]
        ISpread<Vector4D> FOutput;

        [Output("Working")]
        ISpread<bool> FWorking;

        [Output("InterpupillaryDistance")]
        ISpread<float> FInterpupillaryDistance;

        [Output("LensOffset")]
        ISpread<Vector2D> FLensOffset;

        [Output("VerticalFOV")]
        ISpread<float> FVerticalFOV;

        [Output("AspectRatio")]
        ISpread<float> FAspectRatio;

        [Output("DistK")]
        ISpread<Vector4D> FDistK;

        [Output("DistortionScale")]
        ISpread<float> FDistortionScale;

        [Output("Debug")]
        ISpread<string> FDebug;

        //------
        

		[Import()]
		public ILogger FLogger;


		#endregion fields & pins



        OVRDevice device; 

       
		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
            if (FEnabled.IsChanged)
            {
                if (FEnabled[0])
                {
                    InitializeDevice();
                }
                else
                {
                    //device.clear();
                }
            }


            if (device != null)
            {
                OculusSharp.CAPI.Quatf q = device.GetOrientation();
                FOutput.SliceCount = 1;
                FOutput[0] = new Vector4D(q.x, q.y, q.z, q.w);
                //vector[1] = q.y;
                //vector[2] = q.z;
                //vector[3] = q.w;

                OculusSharp.CAPI.Vector3f v = device.getPos();

                position.SliceCount = 1;
                position[0] = new Vector3D(v.x, v.y, v.z);
                //position[1] =v.y;
                //position[2] = v.z;
            }

           
             

		}

        public void InitializeDevice()
        {
            device = new OVRDevice();

            device.init();

            FLogger.Log(LogType.Debug, "Device:  " + device.ToString() + "  initialized");

        }
	}
}
