﻿/*
 * Created by SharpDevelop.
 * User: admin
 * Date: 14.05.2013
 * Time: 11:06
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;
using OVR;

namespace OculusInput
{
	class Program
	{
		// private Camera CameraLeft, CameraRight = null;
		private float  IPD = 0.064f; 							// in millimeters
		private float  LensOffsetLeft, LensOffsetRight = 0.0f;  // normalized screen space
		private float  VerticalFOV = 90.0f;	 					// in degrees
		private float  AspectRatio = 1.0f;						
		private float  DistK0, DistK1, DistK2, DistK3 = 0.0f; 	// lens distortion parameters
		private float  DistortionScale = 0.0f;
		private float RiftPresentTimeout = 10.0f;
		OVRDevice device;
		Quaternion DirQ;
		bool enabled {
			get {
				return OVRDevice.IsInitialized();
			}
			set {
				if(value) {
					device = new OVRDevice();
					device.Awake();
					
					// init OVR
					Console.WriteLine(OVRDevice.DisplayDeviceName);
					Console.WriteLine("" + OVRDevice.HResolution + ", " + OVRDevice.VResolution);
					
					DirQ = new Quaternion(7,2,5,3);
		
					InitCameraControllerVariables();
				}
				else {
					if(device != null) device.OnDestroy();
					device = null;
				}
			}
		}
		
		string debug;
		void CheckIfRiftPresent()
		{
			bool HMDPresent = OVRDevice.IsHMDPresent();
			bool SensorPresent = OVRDevice.IsSensorPresent(0); // 0 is the main head sensor
			
			RiftPresentTimeout = 10.0f; // Keep message up for 10 seconds
				
			if((HMDPresent == false) && (SensorPresent == false))
				debug = "NO HMD AND SENSOR DETECTED";
			else if (HMDPresent == false)
				debug = "NO HMD DETECTED";
			else if (SensorPresent == false)
				debug = "NO SENSOR DETECTED";
			else
				debug = "HMD AND SENSOR DETECTED";
		}
		
		public void InitCameraControllerVariables()
		{
			// Get the IPD value (distance between eyes in meters)
			OVRDevice.GetIPD(ref IPD);
	
			// Get the values for both IPD and lens distortion correction shift. We don't normally
			// need to set the PhysicalLensOffset once it's been set here.
			OVRDevice.CalculatePhysicalLensOffsets(ref LensOffsetLeft, ref LensOffsetRight);
			
			// Using the calculated FOV, based on distortion parameters, yeilds the best results.
			// However, public functions will allow to override the FOV if desired
			VerticalFOV = OVRDevice.VerticalFOV();
			
			// Store aspect ratio as well
			AspectRatio = OVRDevice.CalculateAspectRatio();
			
			DistortionScale = OVRDevice.DistortionScale();
			
			OVRDevice.GetDistortionCorrectionCoefficients(ref DistK0, ref DistK1, ref DistK2, ref DistK3);
		}
		
		public static void Main(string[] args)
		{
			Console.WriteLine("Hello World!");
			Console.ForegroundColor = ConsoleColor.Green;
			
			Program p = new Program();
			p.enabled = true;
			
			Console.WriteLine(p.IPD);
			bool active = true;
			while(active) {
				
				p.DirQ.x = 4;
				OVRDevice.GetOrientation(ref p.DirQ);
				Console.WriteLine(p.DirQ.x + " " + p.DirQ.y + " " + p.DirQ.z + " " + p.DirQ.w);
				OVRDevice.ProcessLatencyInputs();
				System.Threading.Thread.Sleep(10);
			}
			
			p.device.OnDestroy();
			
			Console.Write("Press any key to continue . . . ");
			Console.ReadKey(true);
		}
	}
}