﻿
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using OculusSharp.CAPI;


namespace VVVV.Nodes
{

    class OVRDevice
    {

        Hmd hmd;
        HmdDesc hmdDesc;
        bool initialized;
        float aspectRatio = 0;
        float verticalFOV = 0;

        public void init()
        {
            initialized = Hmd.Initialize();
            
            if (Hmd.DetectHmd() > 0)
            {
               hmd = new Hmd(0);
            }
            else
                hmd = new Hmd(HmdType.Hmd_DK2);

            hmd.ConfigureTracking(TrackingCap.TrackingCap_Orientation | TrackingCap.TrackingCap_MagYawCorrection | TrackingCap.TrackingCap_Position | TrackingCap.TrackingCap_Idle, TrackingCap.TrackingCap_Orientation);

            DistortionMesh dm = new DistortionMesh();
            //hmd.GetFovTextureSize();
            //hmd.CreateDistortionMesh(EyeType.Eye_Count, new FovPort(), DistortionCap.DistortionCap_Chromatic, dm);

            hmdDesc = hmd.GetDesc();

            FovPort fLeft = hmdDesc.DefaultEyeFov1;
            //FovPort fRight = hmdDesc.DefaultEyeFov2;
            FovPort fmax = fLeft;

            float combinedTanHalfFovHorizontal = Math.Max(fmax.LeftTan, fmax.RightTan);
            float combinedTanHalfFovVertical = Math.Max(fmax.UpTan, fmax.DownTan);

            verticalFOV = (float)(1.0 * Math.Atan(combinedTanHalfFovVertical));
            if(combinedTanHalfFovVertical != 0)
            aspectRatio = combinedTanHalfFovHorizontal / combinedTanHalfFovVertical;
            
            
            //Sizei recommenedTex1Size = hmd.GetFovTextureSize(EyeType.Eye_Right, hmdDesc.DefaultEyeFov2, 0.5f);

           
            Vector3f v;
            
           
        }

        
        Posef trackerData;


        public void update()
        {
             trackerData = hmd.GetEyePose(EyeType.Eye_Left);
           
        }

        public Quatf GetOrientation()
        {
            Quatf qf = trackerData.Orientation;

            return qf;
        }


        public Vector3f getPos()
        {
            Vector3f pos = trackerData.Position;

            return pos;
        }

        public float getPupillaryDistance()
        {
            return hmd.GetRenderDesc(EyeType.Eye_Left, hmdDesc.DefaultEyeFov1).ViewAdjust.x;
        }

        public void clear()
        {
            hmd.Dispose();
            Hmd.Shutdown();
        }


        public override string ToString()
        {
            return hmd.ToString();
        }

        
        public float getAspectRatio()
        {
            //hmd.GetRenderDesc(EyeType.Eye_Left, new FovPort()).
            return aspectRatio;
        }

        public float getVerticalFOV()
        {
            return verticalFOV;

        }

        // CalculatePhysicalLensOffsets - Used to offset perspective and distortion shift
        /*
        
        public bool CalculatePhysicalLensOffsets(ref float leftOffset, ref float rightOffset)
        {
            leftOffset = 0.0f;
            rightOffset = 0.0f;

            if (!initialized)
                return false;

           

            float halfHSS = HScreenSize * 0.5f;
            float halfLSD = LensSeparationDistance * 0.5f;

            leftOffset = (((halfHSS - halfLSD) / halfHSS) * 2.0f) - 1.0f;
            rightOffset = ((halfLSD / halfHSS) * 2.0f) - 1.0f;

            return true;
        }
        */

        public bool IsHMDPresent()
        {
            return Hmd.DetectHmd() > 0;
        }

        public string getLastError()
        {
            return hmd.GetLastError();
        }
    }
}
